/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class Changes {
    private Changes() {
    }

    private static Element addReleaseSection(Element element, Release release) {
        return element.addElement("release").addAttribute("date", release.getDateRelease()).addAttribute("version", release.getVersion()).addAttribute("description", release.getDescription());
    }

    public static void generate(Release release, File xmlPath, Log log) throws MojoFailureException {
        Element releaseElement;
        Document document;
        if (!xmlPath.exists()) {
            log.info((CharSequence)("Creating file <" + xmlPath + ">"));
            try {
                xmlPath.getParentFile().mkdirs();
                if (!xmlPath.createNewFile()) {
                    throw new MojoFailureException("<" + xmlPath + "> already exists");
                }
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage());
            }
            DocumentFactory documentFactory = new DocumentFactory();
            Element el = documentFactory.createElement(QName.get((String)"document", (String)"", (String)"http://maven.apache.org/changes/1.0.0"));
            el.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), "http://maven.apache.org/changes/1.0.0 http://maven.apache.org/xsd/changes-1.0.0.xsd");
            document = documentFactory.createDocument(el);
            Element documentElement = document.getRootElement();
            documentElement.addElement("properties");
            Element bodyElement = documentElement.addElement("body");
            releaseElement = Changes.addReleaseSection(bodyElement, release);
        } else {
            log.info((CharSequence)("Reuse existing file <" + xmlPath + ">"));
            try {
                document = new SAXReader().read(xmlPath);
            }
            catch (DocumentException e) {
                throw new MojoFailureException(e.getMessage());
            }
            if (document.selectSingleNode("/document/body/release[@version='" + release.getVersion() + "']") != null) {
                log.debug((CharSequence)("Using existing release node for version <" + release.getVersion() + ">"));
                releaseElement = (Element)Element.class.cast(document.selectSingleNode("/document/body/release[@version='" + release.getVersion() + "']"));
            } else {
                log.debug((CharSequence)("Creating new release node for version <" + release.getVersion() + ">"));
                if (document.selectSingleNode("/document/body") == null) {
                    Element documentElement = document.selectSingleNode("/document") == null ? document.addElement("document") : (Element)Element.class.cast(document.selectSingleNode("/document"));
                    documentElement.addElement("body");
                }
                releaseElement = Changes.addReleaseSection((Element)Element.class.cast(document.selectSingleNode("/document/body")), release);
            }
        }
        if (release.getActions() != null) {
            for (Object object : release.getActions()) {
                Action action = (Action)Action.class.cast(object);
                if (action.getIssue() == null || document.selectSingleNode("/document/body/release[@version='" + release.getVersion() + "']/action[@issue='" + action.getIssue() + "']") == null) {
                    releaseElement.addElement("action").addAttribute("dev", action.getDev()).addAttribute("type", action.getType()).addAttribute("due-to", action.getDueTo()).addAttribute("due-to-email", action.getDueToEmail()).addAttribute("issue", action.getIssue()).addText(action.getAction());
                    continue;
                }
                log.warn((CharSequence)("Action <" + action.getIssue() + "> already exists; skipping"));
            }
        }
        try {
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(xmlPath), OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

