/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import playn.core.AbstractLayer;
import playn.core.Asserts;
import playn.core.GroupLayer;
import playn.core.GroupLayerImpl;
import playn.core.Layer;
import playn.core.ParentLayer;
import playn.java.JavaCanvas;
import playn.java.JavaLayer;
import pythagoras.f.Point;

class JavaGroupLayer
extends JavaLayer
implements GroupLayer,
ParentLayer {
    private GroupLayerImpl<JavaLayer> impl = new GroupLayerImpl();

    JavaGroupLayer() {
    }

    public Layer get(int index) {
        return (Layer)this.impl.children.get(index);
    }

    public void add(Layer layer) {
        Asserts.checkArgument((boolean)(layer instanceof JavaLayer));
        this.impl.add((GroupLayer)this, (AbstractLayer)((JavaLayer)layer));
    }

    @Deprecated
    public void add(int index, Layer layer) {
        Asserts.checkArgument((boolean)(layer instanceof JavaLayer));
        this.impl.add((GroupLayer)this, index, (AbstractLayer)((JavaLayer)layer));
    }

    public void addAt(Layer layer, float tx, float ty) {
        this.impl.addAt((GroupLayer)this, layer, tx, ty);
    }

    public void remove(Layer layer) {
        Asserts.checkArgument((boolean)(layer instanceof JavaLayer));
        this.impl.remove((GroupLayer)this, (AbstractLayer)((JavaLayer)layer));
    }

    @Deprecated
    public void remove(int index) {
        this.impl.remove((GroupLayer)this, index);
    }

    public void clear() {
        this.impl.clear((GroupLayer)this);
    }

    public int size() {
        return this.impl.children.size();
    }

    public void destroy() {
        super.destroy();
        this.impl.destroy((GroupLayer)this);
    }

    public void onAdd() {
        super.onAdd();
        this.impl.onAdd((GroupLayer)this);
    }

    public void onRemove() {
        super.onRemove();
        this.impl.onRemove((GroupLayer)this);
    }

    public Layer hitTestDefault(Point p) {
        return this.impl.hitTest((GroupLayer)this, p);
    }

    public void depthChanged(Layer layer, float oldDepth) {
        this.impl.depthChanged((GroupLayer)this, layer, oldDepth);
    }

    @Override
    void paint(JavaCanvas surf) {
        if (!this.visible()) {
            return;
        }
        surf.save();
        this.transform(surf);
        surf.setAlpha(surf.alpha() * this.alpha);
        for (JavaLayer child : this.impl.children) {
            child.paint(surf);
        }
        surf.restore();
    }
}

