/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.redmine.ta.NotAuthorizedException;
import org.redmine.ta.NotFoundException;
import org.redmine.ta.RedmineAuthenticationException;
import org.redmine.ta.RedmineConfigurationException;
import org.redmine.ta.RedmineException;
import org.redmine.ta.RedmineFormatException;
import org.redmine.ta.RedmineInternalError;
import org.redmine.ta.RedmineProcessingException;
import org.redmine.ta.RedmineTransportException;
import org.redmine.ta.internal.HttpUtil;
import org.redmine.ta.internal.RedmineJSONParser;
import org.redmine.ta.internal.logging.Logger;
import org.redmine.ta.internal.logging.LoggerFactory;

public class Communicator {
    public static final String CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(Communicator.class);
    private String login;
    private String password;

    public String sendRequest(HttpRequest request) throws RedmineException {
        String responseBody;
        HttpResponse httpResponse;
        this.logger.debug(request.getRequestLine().toString());
        DefaultHttpClient httpclient = HttpUtil.getNewHttpClient();
        this.configureProxy(httpclient);
        if (this.login != null) {
            String credentials;
            try {
                credentials = "\"" + Base64.encodeBase64String((byte[])(this.login + ':' + this.password).getBytes(CHARSET)).trim() + "\"";
            }
            catch (UnsupportedEncodingException e) {
                throw new RedmineInternalError(e);
            }
            request.addHeader("Authorization", "Basic: " + credentials);
        }
        request.addHeader("Accept-Encoding", "gzip,deflate");
        try {
            httpResponse = httpclient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e1) {
            throw new RedmineFormatException(e1);
        }
        catch (IOException e1) {
            throw new RedmineTransportException(e1);
        }
        int responseCode = httpResponse.getStatusLine().getStatusCode();
        if (responseCode == 401) {
            throw new RedmineAuthenticationException("Authorization error. Please check if you provided a valid API access key or Login and Password and REST API service is enabled on the server.");
        }
        if (responseCode == 403) {
            throw new NotAuthorizedException("Forbidden. Please check the user has proper permissions.");
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        try {
            responseBody = EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (ParseException e) {
            throw new RedmineFormatException(e);
        }
        catch (IOException e) {
            throw new RedmineTransportException(e);
        }
        if (responseCode == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + responseBody);
        }
        if (responseCode == 422) {
            List<String> errors;
            try {
                errors = RedmineJSONParser.parseErrors(responseBody);
            }
            catch (JSONException e) {
                throw new RedmineFormatException("Bad redmine error responce", e);
            }
            throw new RedmineProcessingException(errors);
        }
        httpclient.getConnectionManager().shutdown();
        return responseBody;
    }

    private void configureProxy(DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port;
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                throw new RedmineConfigurationException("Illegal proxy port " + proxyPort, e);
            }
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public String sendGet(URI uri) throws RedmineException {
        HttpGet http = new HttpGet(uri);
        return this.sendRequest((HttpRequest)http);
    }
}

