/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.logging;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.redmine.ta.internal.logging.DefaultLogger;
import org.redmine.ta.internal.logging.LogLevel;
import org.redmine.ta.internal.logging.Logger;

public final class LoggerFactory {
    private static final String PROPERTIES_FILE_NAME = "redmine.log.properties";
    private static final String PROPERTY_KEY_LOGLEVEL = "log.level";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.INFO;
    private static final Map<String, DefaultLogger> loggers = new HashMap<String, DefaultLogger>();
    private static LogLevel logLevel;

    private LoggerFactory() {
    }

    public static Logger getLogger(String identifier) {
        DefaultLogger logger;
        if (logLevel == null) {
            LoggerFactory.init();
        }
        if ((logger = loggers.get(identifier)) == null) {
            logger = new DefaultLogger(identifier);
            logger.setLogLevel(logLevel);
            loggers.put(identifier, logger);
        }
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getSimpleName());
    }

    private static void init() {
        Properties properties = null;
        try {
            URL url = ClassLoader.getSystemResource(PROPERTIES_FILE_NAME);
            if (url != null) {
                properties = new Properties();
                properties.load(url.openStream());
            }
        }
        catch (IOException ioe) {
            System.err.println("Error when loading logging properties: " + ioe);
        }
        if (properties == null || !properties.containsKey(PROPERTY_KEY_LOGLEVEL)) {
            System.out.println("Using default logging configuration. You can add \"redmine.log.properties\" file to the classpath to override. See http://code.google.com/p/redmine-java-api/issues/detail?id=95");
            properties = LoggerFactory.createDefaultConfiguration();
        }
        try {
            logLevel = LogLevel.valueOf((String)properties.get(PROPERTY_KEY_LOGLEVEL));
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Invalid value for log.level specified in logging configuration redmine.log.properties => using default log level " + (Object)((Object)DEFAULT_LOG_LEVEL));
            logLevel = DEFAULT_LOG_LEVEL;
        }
    }

    private static Properties createDefaultConfiguration() {
        Properties properties = new Properties();
        properties.put(PROPERTY_KEY_LOGLEVEL, DEFAULT_LOG_LEVEL.toString());
        return properties;
    }
}

