/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.redmine.ta.beans.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineIssuesMap {
    private HashMap<Integer, Issue> issuesMap = new HashMap();

    public RedmineIssuesMap(List<Issue> list) {
        for (Issue issue : list) {
            this.issuesMap.put(issue.getId(), issue);
        }
    }

    protected HashMap<Integer, Issue> getIssuesMap() {
        return this.issuesMap;
    }

    public List<Issue> getRootLevelTasks() {
        return this.getChildren(null);
    }

    public List<Issue> getChildren(Issue redmineParentIssue) {
        ArrayList<Issue> rootIssues = new ArrayList<Issue>();
        Iterator<Issue> it = this.issuesMap.values().iterator();
        Integer parentID = null;
        boolean lookingForRootTasks = true;
        if (redmineParentIssue != null) {
            parentID = redmineParentIssue.getId();
            lookingForRootTasks = false;
        }
        while (it.hasNext()) {
            Issue issue = it.next();
            if ((!lookingForRootTasks || issue.getParentId() != null) && (lookingForRootTasks || issue.getParentId() == null || !issue.getParentId().equals(parentID))) continue;
            rootIssues.add(issue);
        }
        return rootIssues;
    }
}

