/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Unmarshaller;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueRelation;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.SavedQuery;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.User;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineXMLParser {
    private static final int UNKNOWN = -1;
    private static final String MAPPING_PROJECTS_LIST = "/mapping_projects_list.xml";
    private static final String MAPPING_ISSUES = "/mapping_issues_list.xml";
    private static final String MAPPING_USERS = "/mapping_users.xml";
    private static final Map<Class, String> fromRedmineMap = new HashMap<Class, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(User.class, RedmineXMLParser.MAPPING_USERS);
            this.put(Issue.class, RedmineXMLParser.MAPPING_ISSUES);
            this.put(Project.class, RedmineXMLParser.MAPPING_PROJECTS_LIST);
            this.put(TimeEntry.class, "/mapping_time_entries.xml");
            this.put(SavedQuery.class, "/mapping_queries.xml");
            this.put(IssueRelation.class, "/mapping_relations.xml");
        }
    };

    public static Issue parseIssueFromXML(String xml) throws RuntimeException {
        StringBuilder b = new StringBuilder(xml);
        RedmineXMLParser.removeBadTags(b);
        return RedmineXMLParser.parseObjectFromXML(Issue.class, b.toString());
    }

    public static Project parseProjectFromXML(String xml) throws RuntimeException {
        return RedmineXMLParser.parseObjectFromXML(Project.class, xml);
    }

    public static List<Issue> parseIssuesFromXML(String xml) throws RuntimeException {
        StringBuilder b = new StringBuilder(xml);
        RedmineXMLParser.removeBadTags(b);
        return RedmineXMLParser.parseObjectsFromXML(Issue.class, b.toString());
    }

    private static void removeBadTags(StringBuilder xml) {
        RedmineXMLParser.replaceAll(xml, "<estimated_hours></estimated_hours>", "");
    }

    public static void replaceAll(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
    }

    public static int parseObjectsTotalCount(String objectsXML) {
        String reg = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?><.+ .*total_count=\"";
        int maxCharsToCheck = Math.min(200, objectsXML.length());
        String first200Chars = objectsXML.substring(0, maxCharsToCheck);
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(first200Chars);
        int result = -1;
        if (matcher.find()) {
            int indexBeginNumber = matcher.end();
            String tmp1 = first200Chars.substring(indexBeginNumber);
            int end = tmp1.indexOf(34);
            String numStr = tmp1.substring(0, end);
            result = Integer.parseInt(numStr);
        }
        return result;
    }

    public static List<Project> parseProjectsFromXML(String xml) {
        return RedmineXMLParser.parseObjectsFromXML(Project.class, xml);
    }

    private static Unmarshaller getUnmarshaller(String configFile, Class<?> classToUse) {
        Unmarshaller unmarshaller;
        InputSource inputSource = new InputSource(RedmineXMLParser.class.getResourceAsStream(configFile));
        ClassLoader cl = RedmineXMLParser.class.getClassLoader();
        Mapping mapping = new Mapping(cl);
        mapping.loadMapping(inputSource);
        try {
            unmarshaller = new Unmarshaller(mapping);
        }
        catch (MappingException e) {
            throw new RuntimeException(e);
        }
        unmarshaller.setClass(classToUse);
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller;
    }

    private static boolean verifyStartsAsXML(String text) {
        String XML_START_PATTERN = "<?xml version=";
        String[] lines = text.split("\\r?\\n");
        if (lines.length > 0 && lines[0].startsWith(XML_START_PATTERN)) {
            return true;
        }
        int charsToShow = text.length() < 500 ? text.length() : 500;
        throw new RuntimeException("RedmineXMLParser: can't parse the response. This is not a valid XML:\n\n" + text.substring(0, charsToShow) + "...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseObjectsFromXML(Class<T> classs, String body) {
        RedmineXMLParser.verifyStartsAsXML(body);
        String configFile = fromRedmineMap.get(classs);
        Unmarshaller unmarshaller = RedmineXMLParser.getUnmarshaller(configFile, ArrayList.class);
        ArrayList list = null;
        StringReader reader = null;
        try {
            reader = new StringReader(body);
            list = (ArrayList)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObjectFromXML(Class<T> classs, String xml) {
        RedmineXMLParser.verifyStartsAsXML(xml);
        StringBuilder b = new StringBuilder(xml);
        RedmineXMLParser.removeBadTags(b);
        String configFile = fromRedmineMap.get(classs);
        Unmarshaller unmarshaller = RedmineXMLParser.getUnmarshaller(configFile, classs);
        Object obj = null;
        StringReader reader = null;
        try {
            reader = new StringReader(b.toString());
            obj = unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return (T)obj;
    }

    public static List<User> parseUsersFromXML(String body) {
        return RedmineXMLParser.parseObjectsFromXML(User.class, body);
    }

    public static User parseUserFromXML(String body) {
        return RedmineXMLParser.parseObjectFromXML(User.class, body);
    }

    public static List<String> parseErrors(String responseBody) {
        ArrayList<String> errors = new ArrayList<String>();
        String[] lines = responseBody.split("\\r?\\n");
        int lineToStartWith = 2;
        int lastLine = lines.length - 1;
        String openTag = "<error>";
        String closeTag = "</error>";
        for (int i = lineToStartWith; i < lastLine; ++i) {
            int begin = lines[i].indexOf(openTag) + openTag.length();
            int end = lines[i].indexOf(closeTag);
            errors.add(lines[i].substring(begin, end));
        }
        return errors;
    }

    public static List<TimeEntry> parseTimeEntries(String xml) {
        return RedmineXMLParser.parseObjectsFromXML(TimeEntry.class, xml);
    }

    public static IssueRelation parseRelationFromXML(String body) {
        return RedmineXMLParser.parseObjectFromXML(IssueRelation.class, body);
    }
}

