/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.redmine.ta.beans.CustomField;
import org.redmine.ta.beans.Identifiable;

public class User
implements Identifiable {
    private Integer id;
    private String login;
    private String password;
    private String firstName;
    private String lastName;
    private String mail;
    private Date createdOn;
    private Date lastLoginOn;
    private List<CustomField> customFields = new ArrayList<CustomField>();

    @Override
    public Integer getId() {
        return this.id;
    }

    public String toString() {
        return this.getFullName();
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastLoginOn() {
        return this.lastLoginOn;
    }

    public void setLastLoginOn(Date lastLoginOn) {
        this.lastLoginOn = lastLoginOn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdOn == null ? 0 : this.createdOn.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastLoginOn == null ? 0 : this.lastLoginOn.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.mail == null ? 0 : this.mail.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.createdOn == null ? other.createdOn != null : !this.createdOn.equals(other.createdOn)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastLoginOn == null ? other.lastLoginOn != null : !this.lastLoginOn.equals(other.lastLoginOn)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.mail == null ? other.mail != null : !this.mail.equals(other.mail)) {
            return false;
        }
        return !(this.password == null ? other.password != null : !this.password.equals(other.password));
    }

    public String getFullName() {
        return this.firstName + " " + this.lastName;
    }

    public void setFullName(String fullName) {
        int ind = fullName.indexOf(32);
        if (ind != -1) {
            this.firstName = fullName.substring(0, ind);
            this.lastName = fullName.substring(ind + 1);
        } else {
            this.firstName = fullName;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCustomField(String fieldName) {
        for (CustomField f : this.customFields) {
            if (!f.getName().equals(fieldName)) continue;
            return f.getValue();
        }
        return null;
    }

    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }
}

