/*
 * Decompiled with CFR 0.152.
 */
package sparsebitmap;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import sparsebitmap.BitmapContainer;
import sparsebitmap.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseBitmap
implements Iterable<Integer>,
BitmapContainer,
Cloneable {
    private static Comparator<SparseBitmap> smallfirst = new Comparator<SparseBitmap>(){

        @Override
        public int compare(SparseBitmap a, SparseBitmap b) {
            return a.sizeInBytes() - b.sizeInBytes();
        }
    };
    public int sizeinwords;
    public int cardinality;
    public static final int MINSTORAGEUSAGE = 32;
    public int[] buffer;
    public int wordusage = 0;
    public static final int WORDSIZE = 32;

    @Override
    public void add(int wo, int off) {
        if (this.wordusage + 2 > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
        this.buffer[this.wordusage++] = off - this.sizeinwords;
        this.buffer[this.wordusage++] = wo;
        this.sizeinwords = off + 1;
        this.cardinality += Integer.bitCount(wo);
    }

    private void fastadd(int wo, int off) {
        if (this.wordusage + 2 > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
        this.buffer[this.wordusage++] = off - this.sizeinwords;
        this.buffer[this.wordusage++] = wo;
        this.sizeinwords = off + 1;
    }

    public boolean equals(Object o) {
        if (o instanceof SparseBitmap) {
            for (int k = 0; k < this.wordusage; ++k) {
                if (this.buffer[k] == ((SparseBitmap)o).buffer[k]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int buf = 0;
        for (int k = 0; k < this.wordusage; ++k) {
            buf = 31 * buf + this.buffer[k];
        }
        return buf;
    }

    public int[] toArray() {
        IntIterator i = this.getIntIterator();
        int[] answer = new int[this.cardinality];
        for (int k = 0; k < this.cardinality; ++k) {
            answer[k] = i.next();
        }
        return answer;
    }

    public static SparseBitmap bitmapOf(int ... k) {
        SparseBitmap s = new SparseBitmap();
        for (int i : k) {
            s.set(i);
        }
        return s;
    }

    public void set(int i) {
        int offset = i - this.sizeinwords * 32;
        if (offset + 32 < 0) {
            throw new IllegalArgumentException("unsupported write back");
        }
        if (offset + 32 >= 0 && offset < 0) {
            int before = this.buffer[this.wordusage - 1];
            int n = this.wordusage - 1;
            this.buffer[n] = this.buffer[n] | 1 << offset + 32;
            if (before != this.buffer[this.wordusage - 1]) {
                ++this.cardinality;
            }
        } else {
            int numberofemptywords = offset / 32;
            this.fastadd(1 << (offset -= numberofemptywords * 32), this.sizeinwords + numberofemptywords);
            ++this.cardinality;
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        final IntIterator under = this.getIntIterator();
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    public IntIterator getIntIterator() {
        return new IntIterator(){
            int wordindex;
            int i = 0;
            int[] buf;
            int max;
            int currentword;

            public IntIterator init(int[] b, int m) {
                this.buf = b;
                this.max = m;
                this.wordindex = this.buf[this.i];
                this.currentword = this.buf[this.i + 1];
                return this;
            }

            public boolean hasNext() {
                return this.currentword != 0;
            }

            public int next() {
                int offset = Integer.numberOfTrailingZeros(this.currentword);
                this.currentword ^= 1 << offset;
                int answer = this.wordindex * 32 + offset;
                if (this.currentword == 0) {
                    this.i += 2;
                    if (this.i < this.max) {
                        this.currentword = this.buf[this.i + 1];
                        this.wordindex += this.buf[this.i] + 1;
                    }
                }
                return answer;
            }
        }.init(this.buffer, this.wordusage);
    }

    public SparseBitmap and(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.and2by2(a, this, o);
        return a;
    }

    public static void and2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer[it1];
        int p2 = bitmap2.buffer[it2];
        while (true) {
            if (p1 < p2) {
                if (it1 + 2 >= bitmap1.wordusage) break;
                p1 += bitmap1.buffer[it1 += 2] + 1;
                continue;
            }
            if (p1 > p2) {
                if (it2 + 2 >= bitmap2.wordusage) break;
                p2 += bitmap2.buffer[it2 += 2] + 1;
                continue;
            }
            int buff = bitmap1.buffer[it1 + 1] & bitmap2.buffer[it2 + 1];
            if (buff != 0) {
                container.add(buff, p1);
            }
            if (it1 + 2 >= bitmap1.wordusage || it2 + 2 >= bitmap2.wordusage) break;
            p1 += bitmap1.buffer[it1 += 2] + 1;
            p2 += bitmap2.buffer[it2 += 2] + 1;
        }
    }

    public SparseBitmap or(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.or2by2(a, this, o);
        return a;
    }

    public static void or2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer[it1];
        int p2 = bitmap2.buffer[it2];
        if (it1 < bitmap1.wordusage && it2 < bitmap2.wordusage) {
            while (true) {
                if (p1 < p2) {
                    container.add(bitmap1.buffer[it1 + 1], p1);
                    if ((it1 += 2) >= bitmap1.wordusage) break;
                    p1 += bitmap1.buffer[it1] + 1;
                    continue;
                }
                if (p1 > p2) {
                    container.add(bitmap2.buffer[it2 + 1], p2);
                    if ((it2 += 2) >= bitmap2.wordusage) break;
                    p2 += bitmap2.buffer[it2] + 1;
                    continue;
                }
                container.add(bitmap1.buffer[it1 + 1] | bitmap2.buffer[it2 + 1], p1);
                it2 += 2;
                if ((it1 += 2) < bitmap1.wordusage) {
                    p1 += bitmap1.buffer[it1] + 1;
                }
                if (it2 < bitmap2.wordusage) {
                    p2 += bitmap2.buffer[it2] + 1;
                }
                if (it1 >= bitmap1.wordusage || it2 >= bitmap2.wordusage) break;
            }
        }
        if (it1 < bitmap1.wordusage) {
            while (true) {
                container.add(bitmap1.buffer[it1 + 1], p1);
                if ((it1 += 2) == bitmap1.wordusage) break;
                p1 += bitmap1.buffer[it1] + 1;
            }
        }
        if (it2 < bitmap2.wordusage) {
            while (true) {
                container.add(bitmap2.buffer[it2 + 1], p2);
                if ((it2 += 2) == bitmap2.wordusage) break;
                p2 += bitmap2.buffer[it2] + 1;
            }
        }
        while (it2 < bitmap2.wordusage) {
            container.add(bitmap2.buffer[it2 + 1], p2);
            p2 += bitmap2.buffer[it2 += 2] + 1;
        }
    }

    public SparseBitmap xor(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.xor2by2(a, this, o);
        return a;
    }

    public static void xor2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer[it1];
        int p2 = bitmap2.buffer[it2];
        if (it1 < bitmap1.wordusage && it2 < bitmap2.wordusage) {
            while (true) {
                if (p1 < p2) {
                    container.add(bitmap1.buffer[it1 + 1], p1);
                    if ((it1 += 2) >= bitmap1.wordusage) break;
                    p1 += bitmap1.buffer[it1] + 1;
                    continue;
                }
                if (p1 > p2) {
                    container.add(bitmap2.buffer[it2 + 1], p2);
                    if ((it2 += 2) >= bitmap2.wordusage) break;
                    p2 += bitmap2.buffer[it2] + 1;
                    continue;
                }
                if (bitmap1.buffer[it1 + 1] != bitmap2.buffer[it2 + 1]) {
                    container.add(bitmap1.buffer[it1 + 1] ^ bitmap2.buffer[it2 + 1], p1);
                }
                it2 += 2;
                if ((it1 += 2) < bitmap1.wordusage) {
                    p1 += bitmap1.buffer[it1] + 1;
                }
                if (it2 < bitmap2.wordusage) {
                    p2 += bitmap2.buffer[it2] + 1;
                }
                if (it1 >= bitmap1.wordusage || it2 >= bitmap2.wordusage) break;
            }
        }
        if (it1 < bitmap1.wordusage) {
            while (true) {
                container.add(bitmap1.buffer[it1 + 1], p1);
                if ((it1 += 2) == bitmap1.wordusage) break;
                p1 += bitmap1.buffer[it1] + 1;
            }
        }
        if (it2 < bitmap2.wordusage) {
            while (true) {
                container.add(bitmap2.buffer[it2 + 1], p2);
                if ((it2 += 2) == bitmap2.wordusage) break;
                p2 += bitmap2.buffer[it2] + 1;
            }
        }
        while (it2 < bitmap2.wordusage) {
            System.out.println("==***= p1 =" + p1 + " p2 = " + p2);
            System.out.println("34%%  p2 = " + p2);
            container.add(bitmap2.buffer[it2 + 1], p2);
            p2 += bitmap2.buffer[it2 += 2] + 1;
        }
    }

    public static SparseBitmap and(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.and(x2));
        }
        return pq.poll();
    }

    public static SparseBitmap or(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].or(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static SparseBitmap xor(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].or(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    @Override
    public int sizeInBytes() {
        return this.wordusage * 4;
    }

    public int compact() {
        if (this.wordusage >= 2) {
            this.buffer = Arrays.copyOf(this.buffer, this.wordusage);
        }
        return this.buffer.length * 4;
    }

    public SparseBitmap() {
        this(32);
    }

    public SparseBitmap(int expectedstoragesize) {
        this.buffer = new int[expectedstoragesize];
    }

    public void clear() {
        this.wordusage = 0;
        Arrays.fill(this.buffer, 0);
        this.sizeinwords = 0;
        this.cardinality = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SparseBitmap b = (SparseBitmap)super.clone();
        b.buffer = Arrays.copyOf(this.buffer, this.buffer.length);
        b.wordusage = this.wordusage;
        b.sizeinwords = this.sizeinwords;
        b.cardinality = this.cardinality;
        return b;
    }
}

