/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.usc.folder.compression;

import com.googlecode.usc.folder.compression.Strategy;
import com.googlecode.usc.folder.compression.utils.CompressionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipStrategy
implements Strategy {
    private static final int BUFFER_SIZE = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCompress(File[] files, File out, List<String> excludedKeys) {
        HashMap<String, File> map = new HashMap<String, File>();
        String parent = FilenameUtils.getBaseName((String)out.getName());
        for (File f : files) {
            CompressionUtil.list(f, parent, map, excludedKeys);
        }
        if (!map.isEmpty()) {
            ZipArchiveOutputStream zos = null;
            try {
                zos = new ZipArchiveOutputStream(out);
                for (Map.Entry entry : map.entrySet()) {
                    File file = (File)entry.getValue();
                    ZipArchiveEntry ze = new ZipArchiveEntry(file, (String)entry.getKey());
                    zos.putArchiveEntry((ArchiveEntry)ze);
                    if (file.isFile()) {
                        FileInputStream is = new FileInputStream(file);
                        byte[] b = new byte[128];
                        int i = -1;
                        while ((i = ((InputStream)is).read(b)) != -1) {
                            zos.write(b, 0, i);
                        }
                        ((InputStream)is).close();
                    }
                    zos.closeArchiveEntry();
                }
                zos.finish();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

