/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.accordion;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.accordion.AccordionState;
import com.googlecode.wicketelements.components.accordion.ui.Accordion;
import com.googlecode.wicketelements.components.togglepane.TogglePaneState;
import com.googlecode.wicketelements.components.togglepane.TogglePaneStateEvent;
import com.googlecode.wicketelements.components.togglepane.ui.TogglePane;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultAccordionState
implements AccordionState {
    boolean maximumOneTogglePaneExpanded;
    private final Accordion accordion;
    private final List<TogglePaneState> expandedTogglePaneStates = new ArrayList<TogglePaneState>();

    public DefaultAccordionState(Accordion accordionParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)accordionParam, "Accordion must not be null.");
        this.accordion = accordionParam;
    }

    public boolean isMaximumOneTogglePaneExpanded() {
        return this.maximumOneTogglePaneExpanded;
    }

    public void setMaximumOneTogglePaneExpanded(boolean maximumOneTogglePaneExpandedParam) {
        this.maximumOneTogglePaneExpanded = maximumOneTogglePaneExpandedParam;
    }

    public void disableAllTogglePanes() {
        for (TogglePane current : this.accordion.getTogglePanes()) {
            if (!current.isEnabled()) continue;
            current.toggleEnableState();
        }
    }

    public void enableAllTogglePanes() {
        for (TogglePane current : this.accordion.getTogglePanes()) {
            if (!current.isDisabled()) continue;
            current.toggleEnableState();
        }
    }

    public void collapseAllTogglePanes() {
        for (TogglePane current : this.accordion.getTogglePanes()) {
            if (!current.isExpanded()) continue;
            current.toggleContent();
        }
    }

    public void expandAllTogglePanes() {
        for (TogglePane current : this.accordion.getTogglePanes()) {
            if (!current.isCollapsed()) continue;
            current.toggleContent();
        }
    }

    public final void togglePaneEnabled(TogglePaneStateEvent stateEventParam) {
    }

    public final void togglePaneDisabled(TogglePaneStateEvent stateEventParam) {
    }

    public final void togglePaneCollapsed(TogglePaneStateEvent stateEventParam) {
        this.expandedTogglePaneStates.remove(stateEventParam.getSource());
    }

    public final void togglePaneExpanded(TogglePaneStateEvent stateEventParam) {
        TogglePaneState state = stateEventParam.getSource();
        Reqs.PRE_COND.Logic.requireTrue(this.isTogglePaneBelongingToThisAccordion(state), "Expanded toggle pane does not belong to this accordion!");
        if (this.maximumOneTogglePaneExpanded) {
            Reqs.PRE_COND.Logic.requireTrue(this.expandedTogglePaneStates.size() <= 1, "There must be maximum one expanded pane.");
            ArrayList<TogglePaneState> expandedTogglePanesStatesCopy = new ArrayList<TogglePaneState>(this.expandedTogglePaneStates);
            for (TogglePaneState current : expandedTogglePanesStatesCopy) {
                current.toggleContent();
            }
        }
        this.expandedTogglePaneStates.add(stateEventParam.getSource());
        Reqs.POST_COND.Logic.requireTrue(this.expandedTogglePaneStates.size() == 1, "There must be exactly one expanded pane.");
    }

    private boolean isTogglePaneBelongingToThisAccordion(TogglePaneState togglePaneStateParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)togglePaneStateParam, "TogglePaneState parameter must not be null.");
        boolean belongs = false;
        Iterator<TogglePane> it = this.accordion.getTogglePanes().iterator();
        while (!belongs && it.hasNext()) {
            belongs = togglePaneStateParam.equals(it.next());
        }
        return belongs;
    }
}

