/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.accordion.ui;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.accordion.AccordionState;
import com.googlecode.wicketelements.components.accordion.DefaultAccordionState;
import com.googlecode.wicketelements.components.togglepane.TogglePaneStateEvent;
import com.googlecode.wicketelements.components.togglepane.ui.TogglePane;
import com.googlecode.wicketelements.library.behavior.AttributeAppenderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accordion
extends Panel
implements AccordionState {
    private static final String TOGGLE_PANES_LIST_WICKET_ID = "we-accordion-togglePanes";
    private static final String TOGGLE_PANES_LIST_ELEMENT_WICKET_ID = "we-accordion-togglePane";
    private final List<TogglePane> togglePanes = new ArrayList<TogglePane>();
    private final AccordionState state = new DefaultAccordionState(this);

    @Override
    public void togglePaneEnabled(TogglePaneStateEvent stateEventParam) {
        this.state.togglePaneEnabled(stateEventParam);
    }

    @Override
    public void togglePaneDisabled(TogglePaneStateEvent stateEventParam) {
        this.state.togglePaneDisabled(stateEventParam);
    }

    @Override
    public void togglePaneCollapsed(TogglePaneStateEvent stateEventParam) {
        this.state.togglePaneCollapsed(stateEventParam);
    }

    @Override
    public void togglePaneExpanded(TogglePaneStateEvent stateEventParam) {
        this.state.togglePaneExpanded(stateEventParam);
    }

    @Override
    public boolean isMaximumOneTogglePaneExpanded() {
        return this.state.isMaximumOneTogglePaneExpanded();
    }

    @Override
    public void setMaximumOneTogglePaneExpanded(boolean maximumOneTogglePaneExpandedParam) {
        this.state.setMaximumOneTogglePaneExpanded(maximumOneTogglePaneExpandedParam);
    }

    @Override
    public void disableAllTogglePanes() {
        this.state.disableAllTogglePanes();
    }

    @Override
    public void enableAllTogglePanes() {
        this.state.enableAllTogglePanes();
    }

    @Override
    public void collapseAllTogglePanes() {
        this.state.collapseAllTogglePanes();
    }

    @Override
    public void expandAllTogglePanes() {
        this.state.expandAllTogglePanes();
    }

    public static final String getTogglePanesListElementWicketId() {
        return TOGGLE_PANES_LIST_ELEMENT_WICKET_ID;
    }

    public void addTogglePane(int index, TogglePane togglePaneParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)togglePaneParam, "Toggle pane must not be null.");
        Reqs.PRE_COND.Logic.requireFalse(this.togglePanes.contains(togglePaneParam), "Toggle pane must not already be contained in the accordion.");
        Reqs.PRE_COND.Logic.requireTrue(index < this.togglePanes.size(), "Index must be smaller than value returned by togglePanesQuantity()");
        this.togglePanes.add(index, togglePaneParam);
        this.doOnAddTogglePane(togglePaneParam);
    }

    public void addTogglePane(TogglePane togglePaneParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)togglePaneParam, "Toggle pane must not be null.");
        Reqs.PRE_COND.Logic.requireFalse(this.togglePanes.contains(togglePaneParam), "Toggle pane must not already be contained in the accordion.");
        this.togglePanes.add(togglePaneParam);
        this.doOnAddTogglePane(togglePaneParam);
    }

    private void doOnAddTogglePane(TogglePane togglePaneParam) {
        togglePaneParam.addComponentToUpdateOnAjaxRequest((Component)this);
        boolean wasExpanded = togglePaneParam.isExpanded();
        togglePaneParam.toggleContent();
        togglePaneParam.addEventListener(this);
        togglePaneParam.toggleContent();
    }

    public void removeTogglePane(TogglePane togglePaneParam) {
        this.togglePanes.remove(togglePaneParam);
        togglePaneParam.removeComponentToUpdateOnAjaxRequest((Component)this);
        togglePaneParam.removeEventListener(this);
    }

    public int togglePanesQuantity() {
        return this.togglePanes.size();
    }

    public final List<TogglePane> getTogglePanes() {
        return Collections.unmodifiableList(this.togglePanes);
    }

    public Accordion(String idParam) {
        super(idParam);
        this.setOutputMarkupId(true);
        ListView<TogglePane> lv = new ListView<TogglePane>(TOGGLE_PANES_LIST_WICKET_ID, this.togglePanes){

            protected void populateItem(ListItem<TogglePane> item) {
                TogglePane togglePane = (TogglePane)item.getModelObject();
                item.add(new Component[]{togglePane});
            }
        };
        this.add(new Component[]{lv});
        this.add(new IBehavior[]{AttributeAppenderFactory.newAttributeAppenderForClass((String)"we-accordion")});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }
}

