/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.gravatar;

import com.googlecode.wicketelements.library.behavior.AttributeModifierFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.StringResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GravatarPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final transient String MD5 = "MD5";
    private static final transient String DOT = ".";
    private static final transient String DOT_JPG = ".jpg";
    private static final transient char ZERO = '0';
    private static final transient String WICKET_ID_GRAVATAR_IMG = "gravatarImg";
    private static final transient Logger LOGGER = LoggerFactory.getLogger(GravatarPanel.class);

    public GravatarPanel(String idParam, String emailParam) {
        super(idParam);
        if (emailParam == null) {
            LOGGER.debug(new StringResourceModel("nullEmailParamLogMessage", (Component)this, null).getString());
            this.addDefaultGravatarImage();
        } else {
            try {
                byte[] hash = MessageDigest.getInstance(MD5).digest(emailParam.getBytes());
                StringBuilder hashString = new StringBuilder();
                for (byte elementLocal : hash) {
                    String hex = Integer.toHexString(elementLocal);
                    if (hex.length() == 1) {
                        hashString.append('0');
                        hashString.append(hex.charAt(hex.length() - 1));
                        continue;
                    }
                    hashString.append(hex.substring(hex.length() - 2));
                }
                Image imgLocal = new Image(WICKET_ID_GRAVATAR_IMG);
                imgLocal.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForAlt((String)("http://www.gravatar.com/avatar/" + hashString.toString() + DOT_JPG))});
                imgLocal.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForAlt((String)(new StringResourceModel("gravatarAlt", (Component)this, null) + emailParam + DOT))});
                this.add(new Component[]{imgLocal});
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.info(new StringResourceModel("md5HashAlgoNotFoundLogMessage", (Component)this, null).getString(), (Throwable)ex);
                this.addDefaultGravatarImage();
            }
        }
    }

    private void addDefaultGravatarImage() {
        Image imgLocal = new Image(WICKET_ID_GRAVATAR_IMG);
        imgLocal.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForAlt((String)new StringResourceModel("defaultGravatarImageHref", (Component)this, null).getString())});
        imgLocal.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForAlt((String)new StringResourceModel("defaultGravatarImageAlt", (Component)this, null).getString())});
        this.add(new Component[]{imgLocal});
    }
}

