/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.lists;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.lists.ComponentListModel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentListPanel
extends Panel {
    public static final String LIST_ELEMENT_WICKET_ID = "component";

    public ComponentListPanel(String id, ComponentListModel componentListModelParam) {
        super(id, (IModel)componentListModelParam);
        this.init(componentListModelParam);
    }

    private final void init(ComponentListModel componentListModelParam) {
        ListView<Component> listView = new ListView<Component>("componentList", (IModel)componentListModelParam){

            protected void populateItem(ListItem<Component> itemParam) {
                Component component = (Component)itemParam.getModelObject();
                Reqs.PRE_COND.String.requireNotBlank(component.getId(), "The ComponentList elements must have an id which is not blank.");
                Reqs.PRE_COND.Logic.requireTrue(Objects.equal((Object)ComponentListPanel.LIST_ELEMENT_WICKET_ID, (Object)component.getId()), "The ComponentList elements must have the id: component");
                itemParam.add(new Component[]{component});
                ComponentListPanel.this.onItem(itemParam);
                if (ComponentListPanel.this.isFirstItem((ListItem<Component>)itemParam)) {
                    ComponentListPanel.this.onFirstItem(itemParam);
                }
                if (ComponentListPanel.this.isLastItem((ListItem<Component>)itemParam)) {
                    ComponentListPanel.this.onLastItem(itemParam);
                }
            }
        };
        this.add(new Component[]{listView});
    }

    private boolean isFirstItem(ListItem<Component> itemParam) {
        return true;
    }

    private boolean isLastItem(ListItem<Component> itemParam) {
        return true;
    }

    protected void onItem(ListItem<Component> itemParam) {
    }

    protected void onFirstItem(ListItem<Component> itemParam) {
    }

    protected void onLastItem(ListItem<Component> itemParam) {
    }
}

