/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.locale;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.locale.LocaleModel;
import com.googlecode.wicketelements.components.locale.LocalesListModel;
import com.googlecode.wicketelements.library.behavior.AttributeModifierFactory;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesPanel
extends Panel {
    public LanguagesPanel(String id, LocalesListModel locales) {
        super(id);
        this.init(locales);
    }

    private void init(LocalesListModel locales) {
        this.populateRepeatingView(locales);
    }

    protected void onLocaleLink(Link<Locale> localeLink) {
    }

    protected void onSelectedLocaleLink(Link<Locale> localeLink) {
    }

    private void populateRepeatingView(LocalesListModel locales) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)locales, "The locales list parameter must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(locales.getObject(), "The locales model object must not be null.");
        ListView<Locale> lv = new ListView<Locale>("languages", (List)locales.getObject()){

            protected void populateItem(ListItem<Locale> item) {
                Locale locale = (Locale)item.getModelObject();
                Link<Locale> link = new Link<Locale>("languageLink", (IModel)new LocaleModel(locale)){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        Locale locale = (Locale)this.getModelObject();
                        Session.get().setLocale(locale);
                    }
                };
                String upperCaseLocale = locale.getLanguage().toUpperCase(locale);
                Label languageLabel = new Label("languageLabel", upperCaseLocale);
                languageLabel.setRenderBodyOnly(true);
                link.add(new Component[]{languageLabel});
                if (locale.equals(Session.get().getLocale())) {
                    LanguagesPanel.this.onLocaleLink(link);
                    LanguagesPanel.this.onSelectedLocaleLink(link);
                } else {
                    LanguagesPanel.this.onLocaleLink(link);
                }
                link.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForTitle((String)new StringResourceModel(upperCaseLocale, (Component)this, null).getString())});
                item.add(new Component[]{link});
                item.setOutputMarkupId(true);
            }
        };
        lv.setRenderBodyOnly(true);
        this.add(new Component[]{lv});
    }
}

