/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.menu;

import com.googlecode.wicketelements.components.menu.PageTree;
import com.googlecode.wicketelements.components.menu.PageTreeModel;
import com.googlecode.wicketelements.library.behavior.AttributeModifierFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final PageTreeModel pageTreeModel = new PageTreeModel();
    private ListView<Class<? extends Page>> lv;

    public BreadcrumbPanel(String id) {
        super(id);
    }

    private List<Class<? extends Page>> buildBreadcrumbPageList() {
        ArrayList<Class<? extends Page>> list = new ArrayList<Class<? extends Page>>();
        Class<?> pageClass = this.getPage().getClass();
        PageTree modelObject = this.pageTreeModel.getObject();
        PageTree currentPageTree = modelObject.getPageTree(pageClass);
        if (currentPageTree != null) {
            PageTree currPageTree = currentPageTree;
            while (!currPageTree.isRoot()) {
                if (currPageTree.getPageClass() != null) {
                    list.add(currPageTree.getPageClass());
                }
                currPageTree = currPageTree.getParent();
            }
            if (currPageTree.getPageClass() != null) {
                list.add(currPageTree.getPageClass());
            }
        } else {
            list.add(this.getPage().getClass());
        }
        Collections.reverse(list);
        return list;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.lv == null) {
            this.lv = new ListView<Class<? extends Page>>("breadcrumbs", this.buildBreadcrumbPageList()){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<Class<? extends Page>> item) {
                    final Class pageClass = (Class)item.getModelObject();
                    BookmarkablePageLink<Class<Page>> link = new BookmarkablePageLink<Class<Page>>("breadcrumbLink", pageClass){
                        private static final long serialVersionUID = 1L;

                        protected void onBeforeRender() {
                            super.onBeforeRender();
                            if (pageClass.equals(this.getPage().getClass())) {
                                BreadcrumbPanel.this.onPageLink((Link<Class<Page>>)this);
                                BreadcrumbPanel.this.onCurrentPageLink((Link<Class<Page>>)this);
                            } else {
                                BreadcrumbPanel.this.onPageLink((Link<Class<Page>>)this);
                            }
                        }
                    };
                    Label languageLabel = new Label("breadcrumbLabel", this.getString(pageClass.getCanonicalName()));
                    languageLabel.setRenderBodyOnly(true);
                    link.add(new Component[]{languageLabel});
                    link.add(new IBehavior[]{AttributeModifierFactory.newAttributeAppenderForTitle((String)this.getString(pageClass.getCanonicalName()))});
                    item.add(new Component[]{link});
                    item.setOutputMarkupId(true);
                }
            };
            this.lv.setRenderBodyOnly(true);
            this.add(new Component[]{this.lv});
        }
        this.lv.setList(this.buildBreadcrumbPageList());
    }

    protected void onCurrentPageLink(Link<Class<Page>> pageLink) {
    }

    protected void onPageLink(Link<Class<Page>> pageLink) {
    }
}

