/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.menu;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.menu.PageTreeModel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public MenuPanel(String id, PageTreeModel pages) {
        super(id);
        this.init(pages);
    }

    private void init(PageTreeModel pages) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)pages, "The page tree model parameter must not be null.");
        this.populateRepeatingView(pages);
    }

    private void populateRepeatingView(PageTreeModel pages) {
        ListView<Class<Page>> lv = new ListView<Class<Page>>("breadcrumbs"){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Class<Page>> item) {
                final Class pageClass = (Class)item.getModelObject();
                BookmarkablePageLink<Class<Page>> link = new BookmarkablePageLink<Class<Page>>("breadcrumbLink", pageClass){
                    private static final long serialVersionUID = 1L;

                    protected void onBeforeRender() {
                        super.onBeforeRender();
                        if (pageClass.equals(this.getPage().getClass())) {
                            MenuPanel.this.onPageLink((Link<Class<Page>>)this);
                            MenuPanel.this.onCurrentPageLink((Link<Class<Page>>)this);
                        } else {
                            MenuPanel.this.onPageLink((Link<Class<Page>>)this);
                        }
                    }
                };
                Label languageLabel = new Label("breadcrumbLabel", "hard label");
                languageLabel.setRenderBodyOnly(true);
                link.add(new Component[]{languageLabel});
                item.add(new Component[]{link});
                item.setOutputMarkupId(true);
            }
        };
        lv.setRenderBodyOnly(true);
        this.add(new Component[]{lv});
    }

    protected void onCurrentPageLink(Link<Class<Page>> pageLink) {
    }

    protected void onPageLink(Link<Class<Page>> pageLink) {
    }
}

