/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.menu;

import com.googlecode.jbp.common.requirements.Reqs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageTree {
    private Class<? extends Page> pageClass;
    private List<PageTree> children;
    private PageTree parent;
    private Map<Class<? extends Page>, PageTree> pageMap = new HashMap<Class<? extends Page>, PageTree>();

    public PageTree() {
    }

    public PageTree(Class<? extends Page> pageClassParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClassParam, "Page class parameter must not be null.");
        this.pageClass = pageClassParam;
        this.addToMap(this.pageMap);
    }

    public PageTree(Class<? extends Page> pageClassParam, List<PageTree> childrenParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClassParam, "Page class parameter must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(childrenParam, "Childre trees list must not be null.");
        this.pageClass = pageClassParam;
        this.children = childrenParam;
        if (childrenParam != null) {
            for (PageTree child : childrenParam) {
                child.parent = this;
            }
        }
        this.addToMap(this.pageMap);
    }

    public PageTree(List<PageTree> childrenParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(childrenParam, "Children trees list must not be null.");
        this.children = childrenParam;
        this.addToMap(this.pageMap);
    }

    protected final void addToMap(Map<Class<? extends Page>, PageTree> mapParam) {
        if (this.pageClass != null) {
            mapParam.put(this.pageClass, this);
        }
        if (this.children != null) {
            for (PageTree child : this.children) {
                child.addToMap(mapParam);
            }
        }
    }

    public PageTree getPageTree(Class<? extends Page> pageClass) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClass, "Page class parameter must not be null.");
        return this.pageMap.get(pageClass);
    }

    public Class<? extends Page> getPageClass() {
        return this.pageClass;
    }

    public void setPageClass(Class<? extends Page> pageClassParam) {
        this.pageClass = pageClassParam;
    }

    public PageTree getParent() {
        return this.parent;
    }

    public List<PageTree> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }
}

