/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.togglepane;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.togglepane.TogglePaneState;
import com.googlecode.wicketelements.components.togglepane.TogglePaneStateEvent;
import com.googlecode.wicketelements.components.togglepane.TogglePaneStateListener;
import com.googlecode.wicketelements.components.togglepane.ui.TogglePane;
import java.util.ArrayList;
import java.util.List;

public class DefaultTogglePaneState
implements TogglePaneState {
    private final List<TogglePaneStateListener> listeners = new ArrayList<TogglePaneStateListener>();
    private final TogglePane togglePane;

    public DefaultTogglePaneState(TogglePane togglePaneParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)togglePaneParam, "Toggle pane must not be null.");
        this.togglePane = togglePaneParam;
    }

    public final void addEventListener(TogglePaneStateListener togglePaneStateListenerParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)togglePaneStateListenerParam, "The listener to add must not be null.");
        this.listeners.add(togglePaneStateListenerParam);
    }

    public final void removeEventListener(TogglePaneStateListener togglePaneStateListenerParam) {
        if (togglePaneStateListenerParam != null) {
            this.listeners.remove(togglePaneStateListenerParam);
        }
    }

    public final void toggleContent() {
        boolean visibility = this.togglePane.getContentComponent().isVisible();
        this.togglePane.getContentComponent().setVisible(!visibility);
        TogglePaneStateEvent event = new TogglePaneStateEvent(this.togglePane);
        if (visibility) {
            for (TogglePaneStateListener listener : this.listeners) {
                listener.togglePaneCollapsed(event);
            }
        } else {
            for (TogglePaneStateListener listener : this.listeners) {
                listener.togglePaneExpanded(event);
            }
        }
    }

    public final void toggleEnableState() {
        boolean enabled = this.togglePane.getTitleComponent().isEnabled();
        this.togglePane.getTitleComponent().setEnabled(!enabled);
        TogglePaneStateEvent event = new TogglePaneStateEvent(this.togglePane);
        if (enabled) {
            for (TogglePaneStateListener listener : this.listeners) {
                listener.togglePaneDisabled(event);
            }
        } else {
            for (TogglePaneStateListener listener : this.listeners) {
                listener.togglePaneEnabled(event);
            }
        }
    }

    public final boolean isCollapsed() {
        return !this.isExpanded();
    }

    public final boolean isExpanded() {
        return this.togglePane.getContentComponent().isVisible();
    }

    public final boolean isEnabled() {
        return this.togglePane.getContentComponent().isEnabled();
    }

    public final boolean isDisabled() {
        return !this.isEnabled();
    }
}

