/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.components.togglepane.ui;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.components.togglepane.DefaultTogglePaneState;
import com.googlecode.wicketelements.components.togglepane.TogglePaneState;
import com.googlecode.wicketelements.components.togglepane.TogglePaneStateListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class TogglePane
extends Panel
implements TogglePaneState {
    private static final String TITLE_WICKET_ID = "title";
    private static final String CONTENT_WICKET_ID = "content";
    private final TogglePaneState state;
    private Component titleComponent;
    private Component contentComponent;
    private Set<Component> componentsToUpdateOnAjaxRequest = new HashSet<Component>();

    public void toggleContent() {
        this.state.toggleContent();
    }

    public void toggleEnableState() {
        this.state.toggleEnableState();
    }

    public boolean isCollapsed() {
        return this.state.isCollapsed();
    }

    public boolean isExpanded() {
        return this.state.isExpanded();
    }

    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    public void addEventListener(TogglePaneStateListener togglePaneStateListenerParam) {
        this.state.addEventListener(togglePaneStateListenerParam);
    }

    public void removeEventListener(TogglePaneStateListener togglePaneStateListenerParam) {
        this.state.removeEventListener(togglePaneStateListenerParam);
    }

    public final void addComponentToUpdateOnAjaxRequest(Component componentParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)componentParam, "Component to update on ajax request must not be null.");
        this.componentsToUpdateOnAjaxRequest.add(componentParam);
    }

    public final void removeComponentToUpdateOnAjaxRequest(Component componentParam) {
        if (componentParam != null) {
            this.componentsToUpdateOnAjaxRequest.remove(componentParam);
        }
    }

    public final Component getTitleComponent() {
        return this.titleComponent;
    }

    public final Component getContentComponent() {
        return this.contentComponent;
    }

    protected abstract Component createTitleComponent(String var1);

    protected abstract Component createContentComponent(String var1);

    public final void handleAjaxOnClickEvent(AjaxRequestTarget targetParam) {
        this.handleOnClickEvent();
        this.updateComponentsForAjaxRequest(targetParam);
    }

    public final void handleOnClickEvent() {
        this.toggleContent();
    }

    private final void updateComponentsForAjaxRequest(AjaxRequestTarget targetParam) {
        for (Component current : this.componentsToUpdateOnAjaxRequest) {
            targetParam.addComponent(current);
        }
        targetParam.addComponent((Component)this);
    }

    public TogglePane(String idParam) {
        super(idParam);
        this.titleComponent = this.createTitleComponent(TITLE_WICKET_ID);
        this.contentComponent = this.createContentComponent(CONTENT_WICKET_ID);
        this.add(new Component[]{this.titleComponent});
        this.add(new Component[]{this.contentComponent});
        this.contentComponent.setVisible(false);
        this.setOutputMarkupId(true);
        this.state = new DefaultTogglePaneState(this);
    }
}

