/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.security;

import com.googlecode.jbp.common.annotations.AnnotationHelper;
import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.security.IUser;
import com.googlecode.wicketelements.security.InstantiationSecurityConstraint;
import com.googlecode.wicketelements.security.SecureSession;
import com.googlecode.wicketelements.security.SecurityCheck;
import com.googlecode.wicketelements.security.SecurityConstraint;
import com.googlecode.wicketelements.security.annotations.EnableAction;
import com.googlecode.wicketelements.security.annotations.Factory;
import com.googlecode.wicketelements.security.annotations.ImpliesSecurityAction;
import com.googlecode.wicketelements.security.annotations.InstantiateAction;
import com.googlecode.wicketelements.security.annotations.PageWithSignIn;
import com.googlecode.wicketelements.security.annotations.RenderAction;
import com.googlecode.wicketelements.security.annotations.SecurityActionQualifier;
import com.googlecode.wicketelements.security.annotations.SignIn;
import com.googlecode.wicketelements.security.annotations.SignInRequired;
import com.googlecode.wicketelements.security.annotations.SignOut;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.settings.IApplicationSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AnnotationSecurityCheck
implements SecurityCheck {
    @Override
    public <T extends Component> List<Class<? extends SecurityConstraint>> findSecurityConstraintsForEnable(T componentParam) {
        return Arrays.asList(componentParam.getClass().getAnnotation(EnableAction.class).constraints());
    }

    @Override
    public <T extends Component> List<Class<? extends SecurityConstraint>> findSecurityConstraintsForRender(T componentParam) {
        return Arrays.asList(componentParam.getClass().getAnnotation(RenderAction.class).constraints());
    }

    @Override
    public <T extends Component> List<Class<? extends InstantiationSecurityConstraint>> findSecurityConstraintsForInstantiation(Class<T> componentClassParam) {
        return Arrays.asList(componentClassParam.getAnnotation(InstantiateAction.class).constraints());
    }

    @Override
    public <T extends Component> boolean isAllSecurityConstraintsSatisfiedForAction(T componentParam, List<Class<? extends SecurityConstraint>> securityConstraintsParam) {
        for (Class<? extends SecurityConstraint> constraintClass : securityConstraintsParam) {
            SecurityConstraint constraint = this.instantiateSecurityConstraint(constraintClass);
            if (constraint.isSatisfiedConstraint(componentParam)) continue;
            return false;
        }
        return true;
    }

    private SecurityConstraint instantiateSecurityConstraint(Class<? extends SecurityConstraint> constraintClassParam) {
        try {
            for (Method m : constraintClassParam.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Factory.class)) continue;
                try {
                    return (SecurityConstraint)m.invoke(null, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalStateException("Cannot execute factory method for InstantiationSecurityConstraint: " + constraintClassParam.getName());
                }
            }
            return constraintClassParam.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot instantiate security constraint class.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot instantiate security constraint class.", ex);
        }
    }

    @Override
    public <T extends Component> boolean isAllSecurityConstraintsSatisfiedForInstantiation(Class<T> componentClassParam, List<Class<? extends InstantiationSecurityConstraint>> securityConstraintsParam) {
        for (Class<? extends InstantiationSecurityConstraint> constraintClass : securityConstraintsParam) {
            InstantiationSecurityConstraint constraint = this.instantiateSecurityConstraint(constraintClass);
            if (constraint.isSatisfiedConstraint(componentClassParam)) continue;
            return false;
        }
        return true;
    }

    private InstantiationSecurityConstraint instantiateSecurityConstraint(Class<? extends InstantiationSecurityConstraint> constraintClassParam) {
        try {
            for (Method m : constraintClassParam.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Factory.class)) continue;
                try {
                    return (InstantiationSecurityConstraint)m.invoke(null, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalStateException("Cannot execute factory method for InstantiationSecurityConstraint: " + constraintClassParam.getName());
                }
            }
            return constraintClassParam.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot instantiate security constraint class.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot instantiate security constraint class.", ex);
        }
    }

    @Override
    public final boolean isSecurityAnnotatedComponent(Class<? extends Component> componentClassParam) {
        return AnnotationHelper.isQualifiedAnnotationPresent(componentClassParam, SecurityActionQualifier.class);
    }

    @Override
    public final boolean isAtLeastOnePermissionGivenToUser(Collection<String> permissionsParam) {
        IUser user = SecureSession.get().getUser();
        for (String perm : permissionsParam) {
            if (StringUtils.isBlank((String)perm) || !user.hasPermission(perm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final <T extends Component, A extends Annotation> Set<String> findImpliedPermissions(Class<T> componentClassParam, Class<A> actionAnnotationClass) {
        Reqs.PARAM_REQ.Object.requireNotNull(componentClassParam, "Component class must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(actionAnnotationClass, "Action annotation class must not be null.");
        HashSet<String> impliedPermissions = new HashSet<String>();
        List securityAnnotations = AnnotationHelper.getQualifiedAnnotations(componentClassParam, SecurityActionQualifier.class);
        for (Annotation securityAnnotation : securityAnnotations) {
            Annotation action;
            if (!this.impliesAction(securityAnnotation.annotationType(), actionAnnotationClass)) continue;
            if (securityAnnotation instanceof InstantiateAction) {
                action = (InstantiateAction)securityAnnotation;
                impliedPermissions.add(action.permission());
                continue;
            }
            if (securityAnnotation instanceof RenderAction) {
                action = (RenderAction)securityAnnotation;
                impliedPermissions.add(action.permission());
                continue;
            }
            if (!(securityAnnotation instanceof EnableAction)) continue;
            action = (EnableAction)securityAnnotation;
            impliedPermissions.add(action.permission());
        }
        return impliedPermissions;
    }

    private final <T extends Annotation> boolean impliesAction(Class<T> annotationParam, Class<? extends Annotation> impliedParam) {
        ImpliesSecurityAction a;
        Class<? extends Annotation>[] arr$;
        int len$;
        int i$;
        if (impliedParam.isAssignableFrom(annotationParam)) {
            return true;
        }
        if (annotationParam.isAnnotationPresent(ImpliesSecurityAction.class) && (i$ = 0) < (len$ = (arr$ = (a = annotationParam.getAnnotation(ImpliesSecurityAction.class)).impliedActions()).length)) {
            Class<? extends Annotation> annotClass = arr$[i$];
            return this.impliesAction(annotClass, impliedParam);
        }
        return false;
    }

    @Override
    public final boolean isSignInPage(Class<? extends Page> pageClassParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClassParam, "Sign in page parameter must not be null.");
        return pageClassParam.equals(this.signInPage()) || pageClassParam.isAnnotationPresent(PageWithSignIn.class);
    }

    @Override
    public final boolean isSignOutPage(Class<? extends Page> pageClassParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClassParam, "Sign out page parameter must not be null.");
        return pageClassParam.equals(this.signOutPage());
    }

    @Override
    public final boolean isErrorPage(Class<? extends Page> pageClassParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(pageClassParam, "Eror page parameter must not be null.");
        IApplicationSettings settings = Application.get().getApplicationSettings();
        return pageClassParam.isAssignableFrom(settings.getAccessDeniedPage()) || pageClassParam.isAssignableFrom(settings.getInternalErrorPage()) || pageClassParam.isAssignableFrom(settings.getPageExpiredErrorPage()) || this.isComplementaryErrorPage(pageClassParam);
    }

    protected boolean isComplementaryErrorPage(Class<? extends Page> pageClassParam) {
        return false;
    }

    @Override
    public final boolean isSignInRequired() {
        return Application.get().getClass().isAnnotationPresent(SignInRequired.class);
    }

    @Override
    public final boolean isApplicationWithSignInPageSpecified() {
        if (Application.get().getClass().isAnnotationPresent(SignIn.class)) {
            SignIn annot = Application.get().getClass().getAnnotation(SignIn.class);
            return annot.page() != null;
        }
        return false;
    }

    @Override
    public final Class<? extends Page> signInPage() {
        Class<? extends Page> page = Application.get().getHomePage();
        if (Application.get().getClass().isAnnotationPresent(SignIn.class)) {
            SignIn annot = Application.get().getClass().getAnnotation(SignIn.class);
            page = annot.page();
        }
        return page;
    }

    @Override
    public final Class<? extends Page> signOutPage() {
        Class<? extends Page> page = null;
        if (Application.get().getClass().isAnnotationPresent(SignOut.class)) {
            SignOut annot = Application.get().getClass().getAnnotation(SignOut.class);
            page = annot.page();
        }
        return page;
    }
}

