/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.security;

import com.googlecode.wicketelements.security.SecureSession;
import com.googlecode.wicketelements.security.SecurityCheck;
import com.googlecode.wicketelements.security.SignOutPage;
import com.googlecode.wicketelements.security.annotations.SignOut;
import org.apache.wicket.Application;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.protocol.http.WebApplication;

@SignOut(page=SignOutPage.class)
public abstract class SecureWebApplication
extends WebApplication {
    private IAuthorizationStrategy authorizationStrategy;
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener;
    private SecurityCheck securityCheck;

    public SecureWebApplication(IAuthorizationStrategy authorizationStrategyParam, IUnauthorizedComponentInstantiationListener unauthorizedInstListenerParam, SecurityCheck securityCheckParam) {
        this.authorizationStrategy = authorizationStrategyParam;
        this.unauthorizedComponentInstantiationListener = unauthorizedInstListenerParam;
        this.securityCheck = securityCheckParam;
    }

    public SecureWebApplication() {
    }

    protected void init() {
        super.init();
        if (this.authorizationStrategy != null) {
            this.getSecuritySettings().setAuthorizationStrategy(this.authorizationStrategy);
            this.getSecuritySettings().setUnauthorizedComponentInstantiationListener(this.unauthorizedComponentInstantiationListener);
        }
    }

    public static SecureWebApplication get() {
        return (SecureWebApplication)Application.get();
    }

    public Session newSession(Request request, Response response) {
        return new SecureSession(request);
    }

    public SecurityCheck getSecurityCheck() {
        return this.securityCheck;
    }
}

