/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.security;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.security.SecureSession;
import com.googlecode.wicketelements.security.SecurityCheck;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnauthorizedComponentInstantiationListener
implements IUnauthorizedComponentInstantiationListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger((String)"wicketelements.security");
    private SecurityCheck securityCheck;

    public UnauthorizedComponentInstantiationListener(SecurityCheck securityCheckParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)securityCheckParam, "The SecurityCheck object must not be null.");
        this.securityCheck = securityCheckParam;
    }

    public void onUnauthorizedInstantiation(Component componentParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)componentParam, "The component parameter must not be null.");
        if (!SecureSession.get().isAuthenticated()) {
            LOGGER.debug("Unauthorized and user not authenticated.");
            if (this.securityCheck.isApplicationWithSignInPageSpecified()) {
                LOGGER.debug("Application has a sign in page specified. Setting sign in page as response.");
                throw new RestartResponseAtInterceptPageException(this.securityCheck.signInPage());
            }
        }
        LOGGER.debug("Setting access denied page as response.");
        throw new RestartResponseException(WebApplication.get().getApplicationSettings().getAccessDeniedPage());
    }
}

