/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.security;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.security.IUser;
import com.googlecode.wicketelements.security.InstantiationSecurityConstraint;
import com.googlecode.wicketelements.security.SecureSession;
import com.googlecode.wicketelements.security.SecurityCheck;
import com.googlecode.wicketelements.security.SecurityConstraint;
import com.googlecode.wicketelements.security.annotations.EnableAction;
import com.googlecode.wicketelements.security.annotations.InstantiateAction;
import com.googlecode.wicketelements.security.annotations.RenderAction;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAuthorizationStrategy
implements IAuthorizationStrategy {
    private static final transient Logger LOGGER = LoggerFactory.getLogger((String)"wicketelements.security");
    private SecurityCheck securityCheck;

    public AnnotationAuthorizationStrategy(SecurityCheck securityCheckParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)securityCheckParam, "SecurityCheck object must not be null.");
        this.securityCheck = securityCheckParam;
    }

    public <T extends Component> boolean isInstantiationAuthorized(Class<T> componentClassParam) {
        LOGGER.debug("Checking if instantiation is authorized for {}", (Object)componentClassParam.getName());
        Reqs.PARAM_REQ.Object.requireNotNull(componentClassParam, "The component's class parameter must not be null.");
        if (this.securityCheck.isSignInRequired()) {
            LOGGER.debug("Sign in is required.");
            if (!SecureSession.get().isAuthenticated()) {
                LOGGER.debug("User is not authenticated.");
                if (Page.class.isAssignableFrom(componentClassParam)) {
                    LOGGER.debug("Component is a Page.");
                    Class<T> p = componentClassParam;
                    if (this.securityCheck.isErrorPage(p) || this.securityCheck.isSignInPage(p) || this.securityCheck.isSignOutPage(p)) {
                        LOGGER.debug("Page is an error, sign in or sign out page.");
                        return true;
                    }
                    return false;
                }
            }
        }
        if (this.securityCheck.isSecurityAnnotatedComponent(componentClassParam)) {
            Set<String> permissions = this.securityCheck.findImpliedPermissions(componentClassParam, InstantiateAction.class);
            boolean userHasPermission = this.securityCheck.isAtLeastOnePermissionGivenToUser(permissions);
            List<Class<? extends InstantiationSecurityConstraint>> constraints = this.securityCheck.findSecurityConstraintsForInstantiation(componentClassParam);
            boolean constraintsSatisfied = this.securityCheck.isAllSecurityConstraintsSatisfiedForInstantiation(componentClassParam, constraints);
            return constraintsSatisfied && userHasPermission;
        }
        return true;
    }

    public boolean isActionAuthorized(Component componentParam, Action actionParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)componentParam, "The component parameter must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull((Object)actionParam, "The action parameter must not be null.");
        Class<?> componentClass = componentParam.getClass();
        if (this.securityCheck.isSecurityAnnotatedComponent(componentClass)) {
            IUser user = SecureSession.get().getUser();
            if (user != null) {
                Class securityAnnotationClass = null;
                List<Class<? extends SecurityConstraint>> constraints = null;
                if (Component.RENDER.equals(actionParam)) {
                    securityAnnotationClass = RenderAction.class;
                    constraints = this.securityCheck.findSecurityConstraintsForRender(componentParam);
                } else if (Component.ENABLE.equals(actionParam)) {
                    securityAnnotationClass = EnableAction.class;
                    if (!this.isActionAuthorized((Component)componentParam.getParent(), actionParam)) {
                        return false;
                    }
                    constraints = this.securityCheck.findSecurityConstraintsForEnable(componentParam);
                }
                if (securityAnnotationClass == null) {
                    throw new IllegalStateException("Action is unknown (Render or Enable expected).: " + actionParam);
                }
                boolean constraintsSatisfied = this.securityCheck.isAllSecurityConstraintsSatisfiedForAction(componentParam, constraints);
                Set<String> permissions = this.securityCheck.findImpliedPermissions(componentClass, securityAnnotationClass);
                boolean userHasPermission = this.securityCheck.isAtLeastOnePermissionGivenToUser(permissions);
                return constraintsSatisfied && userHasPermission;
            }
        } else {
            LOGGER.debug("No security annotation on the component.  Action is authorized.");
            return true;
        }
        return true;
    }
}

