/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicketelements.security;

import com.googlecode.jbp.common.requirements.Reqs;
import com.googlecode.wicketelements.security.IUser;
import com.googlecode.wicketelements.security.SessionInvalidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Request;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureSession
extends WebSession {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SecureSession.class);
    private IUser user = IUser.NO_PERMISSIONS_USER;
    private List<SessionInvalidator> invalidators = Collections.emptyList();

    public void addInvalidator(SessionInvalidator invalidatorParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)invalidatorParam, "Impossible to add a invalidator which is null.");
        if (this.invalidators.equals(Collections.emptyList())) {
            this.invalidators = new ArrayList<SessionInvalidator>();
        }
        this.invalidators.add(invalidatorParam);
    }

    public void removeInvalidator(SessionInvalidator invalidatorParam) {
        this.invalidators.remove(invalidatorParam);
    }

    public SecureSession(Request request) {
        super(request);
    }

    public static SecureSession get() {
        return (SecureSession)Session.get();
    }

    public IUser getUser() {
        return this.user;
    }

    public void switchUser(IUser userParam) {
        Reqs.PARAM_REQ.Object.requireNotNull((Object)userParam, "The user parameter must not be null.");
        this.user = userParam;
    }

    public boolean isAuthenticated() {
        return this.user != null && this.user != IUser.NO_PERMISSIONS_USER;
    }

    public void invalidate() {
        LOGGER.debug("Invalidating session with user {} and id {}.", (Object)this.user, (Object)Session.get().getId());
        this.commonInvalidate();
        super.invalidate();
    }

    public void invalidateNow() {
        LOGGER.debug("Invalidating now session with user: {}", (Object)this.user);
        this.commonInvalidate();
        super.invalidateNow();
    }

    private void commonInvalidate() {
        this.user = IUser.NO_PERMISSIONS_USER;
        this.runCustomInvalidators();
    }

    private void runCustomInvalidators() {
        for (SessionInvalidator current : this.invalidators) {
            current.invalidate((WebSession)WebSession.get());
        }
    }
}

