/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.ReferentialIntegrityError;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Fare;
import java.io.IOException;
import java.util.Map;

public class FareRule
extends Entity {
    private static final long serialVersionUID = 3209660216692732272L;
    public String fare_id;
    public String route_id;
    public String origin_id;
    public String destination_id;
    public String contains_id;

    public static class Loader
    extends Entity.Loader<FareRule> {
        private final Map<String, Fare> fares;

        public Loader(GTFSFeed feed, Map<String, Fare> fares) {
            super(feed, "fare_rules");
            this.fares = fares;
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            String fareId = this.getStringField("fare_id", true);
            if (!this.fares.containsKey(fareId)) {
                this.feed.errors.add(new ReferentialIntegrityError(this.tableName, this.row, "fare_id", fareId));
            }
            Fare fare = this.fares.computeIfAbsent(fareId, Fare::new);
            FareRule fr = new FareRule();
            fr.sourceFileLine = this.row + 1L;
            fr.fare_id = fare.fare_id;
            fr.route_id = this.getStringField("route_id", false);
            fr.origin_id = this.getStringField("origin_id", false);
            fr.destination_id = this.getStringField("destination_id", false);
            fr.contains_id = this.getStringField("contains_id", false);
            fr.feed = this.feed;
            fare.fare_rules.add(fr);
        }
    }
}

