/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GraphExplorer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Label {
    public boolean deleted = false;
    public final long currentTime;
    public final GraphExplorer.MultiModalEdge edge;
    public final NodeId node;
    public final int nTransfers;
    public final Long departureTime;
    public final long streetTime;
    public final long extraWeight;
    final long residualDelay;
    final boolean impossible;
    public final Label parent;

    Label(long currentTime, GraphExplorer.MultiModalEdge edge, NodeId node, int nTransfers, Long departureTime, long streetTime, long extraWeight, long residualDelay, boolean impossible, Label parent) {
        this.currentTime = currentTime;
        this.edge = edge;
        this.node = node;
        this.nTransfers = nTransfers;
        this.departureTime = departureTime;
        this.streetTime = streetTime;
        this.extraWeight = extraWeight;
        this.residualDelay = residualDelay;
        this.impossible = impossible;
        this.parent = parent;
    }

    public String toString() {
        return this.node + " " + (this.departureTime != null ? Instant.ofEpochMilli(this.departureTime) : "---") + "\t" + this.nTransfers + "\t" + Instant.ofEpochMilli(this.currentTime);
    }

    static List<Transition> getTransitions(Label _label, boolean arriveBy) {
        Label label = _label;
        boolean reverseEdgeFlags = !arriveBy;
        ArrayList<Transition> result = new ArrayList<Transition>();
        if (!reverseEdgeFlags) {
            result.add(new Transition(label, null));
        }
        while (label.parent != null) {
            Transition transition = reverseEdgeFlags ? new Transition(label, label.edge) : new Transition(label.parent, label.edge);
            label = label.parent;
            result.add(transition);
        }
        if (reverseEdgeFlags) {
            result.add(new Transition(label, null));
            Collections.reverse(result);
        }
        return result;
    }

    public static class NodeId {
        public int streetNode;
        public int ptNode;

        public NodeId(int streetNode, int ptNode) {
            this.streetNode = streetNode;
            this.ptNode = ptNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeId nodeId = (NodeId)o;
            return this.streetNode == nodeId.streetNode && this.ptNode == nodeId.ptNode;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.streetNode;
            result = 31 * result + this.ptNode;
            return result;
        }

        public String toString() {
            return "NodeId{streetNode=" + this.streetNode + ", ptNode=" + this.ptNode + '}';
        }
    }

    static class Transition {
        final Label label;
        final GraphExplorer.MultiModalEdge edge;

        Transition(Label label, GraphExplorer.MultiModalEdge edge) {
            this.label = label;
            this.edge = edge;
        }

        public String toString() {
            return (this.edge != null ? this.edge.toString() + " -> " : "") + this.label.node;
        }
    }
}

