/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntToLongFunction;
import java.util.function.Predicate;

public class MultiCriteriaLabelSetting {
    private final Comparator<Label> queueComparator;
    private final List<Label> targetLabels;
    private long startTime;
    private final Map<Label.NodeId, List<Label>> fromMap;
    private final PriorityQueue<Label> fromHeap;
    private final long maxProfileDuration;
    private final boolean reverse;
    private final boolean mindTransfers;
    private final boolean profileQuery;
    private final GraphExplorer explorer;
    private double betaTransfers = 0.0;
    private IntToLongFunction transferPenaltiesByRouteType = routeType -> 0L;
    private double betaStreetTime = 1.0;
    private long limitTripTime = Long.MAX_VALUE;
    private long limitStreetTime = Long.MAX_VALUE;

    public MultiCriteriaLabelSetting(GraphExplorer explorer, boolean reverse, boolean mindTransfers, boolean profileQuery, long maxProfileDuration, List<Label> solutions) {
        this.explorer = explorer;
        this.reverse = reverse;
        this.mindTransfers = mindTransfers;
        this.profileQuery = profileQuery;
        this.maxProfileDuration = maxProfileDuration;
        this.targetLabels = solutions;
        this.queueComparator = new LabelComparator();
        this.fromHeap = new PriorityQueue<Label>(this.queueComparator);
        this.fromMap = new HashMap<Label.NodeId, List<Label>>();
    }

    public Iterable<Label> calcLabels(Label.NodeId from, Instant startTime) {
        this.startTime = startTime.toEpochMilli();
        return () -> Spliterators.iterator(new MultiCriteriaLabelSettingSpliterator(from));
    }

    void setBetaTransfers(double betaTransfers) {
        this.betaTransfers = betaTransfers;
    }

    void setBetaStreetTime(double betaWalkTime) {
        this.betaStreetTime = betaWalkTime;
    }

    void setBoardingPenaltyByRouteType(IntToLongFunction transferPenaltiesByRouteType) {
        this.transferPenaltiesByRouteType = transferPenaltiesByRouteType;
    }

    void insertIfNotDominated(Label me) {
        List sptEntries;
        Predicate<Label> filter = this.profileQuery && me.departureTime != null ? targetLabel -> !this.reverse ? this.prc(me, (Label)targetLabel) : this.rprc(me, (Label)targetLabel) : label -> true;
        if (this.isNotDominatedByAnyOf(me, this.targetLabels, filter) && this.isNotDominatedByAnyOf(me, sptEntries = this.fromMap.computeIfAbsent(me.node, k -> new ArrayList(1)), filter)) {
            this.removeDominated(me, sptEntries, filter);
            sptEntries.add(me);
            this.fromHeap.add(me);
        }
    }

    boolean rprc(Label me, Label they) {
        return they.departureTime != null && (they.departureTime <= me.departureTime || they.departureTime <= this.startTime - this.maxProfileDuration);
    }

    boolean prc(Label me, Label they) {
        return they.departureTime != null && (they.departureTime >= me.departureTime || they.departureTime >= this.startTime + this.maxProfileDuration);
    }

    boolean isNotDominatedByAnyOf(Label me, Collection<Label> sptEntries, Predicate<Label> filter) {
        for (Label they : sptEntries) {
            if (!filter.test(they) || !this.dominates(they, me)) continue;
            return false;
        }
        return true;
    }

    void removeDominated(Label me, Collection<Label> sptEntries, Predicate<Label> filter) {
        Iterator<Label> iterator = sptEntries.iterator();
        while (iterator.hasNext()) {
            Label sptEntry = iterator.next();
            if (!filter.test(sptEntry) || !this.dominates(me, sptEntry)) continue;
            sptEntry.deleted = true;
            iterator.remove();
        }
    }

    private boolean dominates(Label me, Label they) {
        if (this.weight(me) > this.weight(they)) {
            return false;
        }
        if (this.mindTransfers && me.nTransfers > they.nTransfers) {
            return false;
        }
        if (me.impossible && !they.impossible) {
            return false;
        }
        if (this.weight(me) < this.weight(they)) {
            return true;
        }
        if (this.mindTransfers && me.nTransfers < they.nTransfers) {
            return true;
        }
        return this.queueComparator.compare(me, they) <= 0;
    }

    long weight(Label label) {
        return this.timeSinceStartTime(label) + (long)((double)label.nTransfers * this.betaTransfers) + (long)((double)label.streetTime * (this.betaStreetTime - 1.0)) + label.extraWeight;
    }

    long timeSinceStartTime(Label label) {
        return (long)(this.reverse ? -1 : 1) * (label.currentTime - this.startTime);
    }

    Long departureTimeSinceStartTime(Label label) {
        return label.departureTime != null ? Long.valueOf((long)(this.reverse ? -1 : 1) * (label.departureTime - this.startTime)) : null;
    }

    public void setLimitTripTime(long limitTripTime) {
        this.limitTripTime = limitTripTime;
    }

    public void setLimitStreetTime(long limitStreetTime) {
        this.limitStreetTime = limitStreetTime;
    }

    private class LabelComparator
    implements Comparator<Label> {
        private LabelComparator() {
        }

        @Override
        public int compare(Label o1, Label o2) {
            int c = Long.compare(MultiCriteriaLabelSetting.this.weight(o1), MultiCriteriaLabelSetting.this.weight(o2));
            if (c != 0) {
                return c;
            }
            c = Integer.compare(o1.nTransfers, o2.nTransfers);
            if (c != 0) {
                return c;
            }
            c = Long.compare(o1.streetTime, o2.streetTime);
            if (c != 0) {
                return c;
            }
            c = Long.compare(o1.departureTime != null ? (MultiCriteriaLabelSetting.this.reverse ? o1.departureTime : -o1.departureTime.longValue()) : 0L, o2.departureTime != null ? (MultiCriteriaLabelSetting.this.reverse ? o2.departureTime : -o2.departureTime.longValue()) : 0L);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(o1.impossible ? 1 : 0, o2.impossible ? 1 : 0);
            return c;
        }
    }

    private class MultiCriteriaLabelSettingSpliterator
    extends Spliterators.AbstractSpliterator<Label> {
        MultiCriteriaLabelSettingSpliterator(Label.NodeId from) {
            super(0L, 0);
            Label label = new Label(MultiCriteriaLabelSetting.this.startTime, null, from, 0, null, 0L, 0L, 0L, false, null);
            ArrayList<Label> labels = new ArrayList<Label>(1);
            labels.add(label);
            MultiCriteriaLabelSetting.this.fromMap.put(from, labels);
            MultiCriteriaLabelSetting.this.fromHeap.add(label);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Label> action) {
            while (!MultiCriteriaLabelSetting.this.fromHeap.isEmpty() && ((Label)((MultiCriteriaLabelSetting)MultiCriteriaLabelSetting.this).fromHeap.peek()).deleted) {
                MultiCriteriaLabelSetting.this.fromHeap.poll();
            }
            if (MultiCriteriaLabelSetting.this.fromHeap.isEmpty()) {
                return false;
            }
            Label label = (Label)MultiCriteriaLabelSetting.this.fromHeap.poll();
            action.accept(label);
            for (GraphExplorer.MultiModalEdge edge : MultiCriteriaLabelSetting.this.explorer.exploreEdgesAround(label)) {
                boolean impossible;
                long walkTime;
                long nextTime = MultiCriteriaLabelSetting.this.reverse ? label.currentTime - MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis(edge, label.currentTime) : label.currentTime + MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis(edge, label.currentTime);
                int nTransfers = label.nTransfers + edge.getTransfers();
                long extraWeight = label.extraWeight;
                Long firstPtDepartureTime = label.departureTime;
                GtfsStorage.EdgeType edgeType = edge.getType();
                if (!MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.ENTER_PT || MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.EXIT_PT) {
                    extraWeight += MultiCriteriaLabelSetting.this.transferPenaltiesByRouteType.applyAsLong(edge.getRouteType());
                }
                if (edgeType == GtfsStorage.EdgeType.TRANSFER) {
                    extraWeight += MultiCriteriaLabelSetting.this.transferPenaltiesByRouteType.applyAsLong(edge.getRouteType());
                }
                if (!(MultiCriteriaLabelSetting.this.reverse || edgeType != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK && edgeType != GtfsStorage.EdgeType.WAIT)) {
                    if (label.nTransfers == 0) {
                        firstPtDepartureTime = nextTime - label.streetTime;
                    }
                } else if (MultiCriteriaLabelSetting.this.reverse && (edgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK || edgeType == GtfsStorage.EdgeType.WAIT_ARRIVAL) && label.nTransfers == 0) {
                    firstPtDepartureTime = nextTime + label.streetTime;
                }
                if ((walkTime = label.streetTime + (edgeType == GtfsStorage.EdgeType.HIGHWAY || edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.EXIT_PT ? (long)(MultiCriteriaLabelSetting.this.reverse ? -1 : 1) * (nextTime - label.currentTime) : 0L)) > MultiCriteriaLabelSetting.this.limitStreetTime || Math.abs(nextTime - MultiCriteriaLabelSetting.this.startTime) > MultiCriteriaLabelSetting.this.limitTripTime) continue;
                boolean result = false;
                if (label.edge != null) {
                    boolean bl = result = label.edge.getType() == GtfsStorage.EdgeType.EXIT_PT;
                }
                if (edgeType == GtfsStorage.EdgeType.ENTER_PT && result) continue;
                boolean bl = impossible = label.impossible || MultiCriteriaLabelSetting.this.explorer.isBlocked(edge) || !MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.BOARD && label.residualDelay > 0L || MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.ALIGHT && label.residualDelay < MultiCriteriaLabelSetting.this.explorer.getDelayFromAlightEdge(edge, label.currentTime);
                long residualDelay = !MultiCriteriaLabelSetting.this.reverse ? (edgeType == GtfsStorage.EdgeType.WAIT || edgeType == GtfsStorage.EdgeType.TRANSFER ? Math.max(0L, label.residualDelay - MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis(edge, label.currentTime)) : (edgeType == GtfsStorage.EdgeType.ALIGHT ? label.residualDelay + MultiCriteriaLabelSetting.this.explorer.getDelayFromAlightEdge(edge, label.currentTime) : (edgeType == GtfsStorage.EdgeType.BOARD ? -MultiCriteriaLabelSetting.this.explorer.getDelayFromBoardEdge(edge, label.currentTime) : label.residualDelay))) : (edgeType == GtfsStorage.EdgeType.WAIT || edgeType == GtfsStorage.EdgeType.TRANSFER ? label.residualDelay + MultiCriteriaLabelSetting.this.explorer.calcTravelTimeMillis(edge, label.currentTime) : 0L);
                if (!MultiCriteriaLabelSetting.this.reverse && edgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK && residualDelay > 0L) {
                    Label newImpossibleLabelForDelayedTrip = new Label(nextTime, edge, edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, extraWeight, residualDelay, true, label);
                    MultiCriteriaLabelSetting.this.insertIfNotDominated(newImpossibleLabelForDelayedTrip);
                    nextTime += residualDelay;
                    residualDelay = 0L;
                    Label newLabel = new Label(nextTime, edge, edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, extraWeight, residualDelay, impossible, label);
                    MultiCriteriaLabelSetting.this.insertIfNotDominated(newLabel);
                    continue;
                }
                Label newLabel = new Label(nextTime, edge, edge.getAdjNode(), nTransfers, firstPtDepartureTime, walkTime, extraWeight, residualDelay, impossible, label);
                MultiCriteriaLabelSetting.this.insertIfNotDominated(newLabel);
            }
            return true;
        }
    }
}

