/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GHPointLocation;
import com.graphhopper.gtfs.GHStationLocation;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class PtLocationSnapper {
    BaseGraph baseGraph;
    LocationIndex locationIndex;
    GtfsStorage gtfsStorage;

    public PtLocationSnapper(BaseGraph baseGraph, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
        this.baseGraph = baseGraph;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
    }

    public Result snapAll(List<GHLocation> locations, List<EdgeFilter> snapFilters) {
        PointList points = new PointList(2, false);
        ArrayList<Snap> pointSnaps = new ArrayList<Snap>();
        ArrayList<Supplier<Label.NodeId>> allSnaps = new ArrayList<Supplier<Label.NodeId>>();
        for (int i = 0; i < locations.size(); ++i) {
            GHLocation location = locations.get(i);
            if (location instanceof GHPointLocation) {
                GHPoint point = ((GHPointLocation)location).ghPoint;
                Snap snap = this.locationIndex.findClosest(point.lat, point.lon, snapFilters.get(i));
                if (!snap.isValid()) {
                    IntHashSet result = new IntHashSet();
                    this.gtfsStorage.getStopIndex().findEdgeIdsInNeighborhood(point.lat, point.lon, 0, arg_0 -> ((IntHashSet)result).add(arg_0));
                    this.gtfsStorage.getStopIndex().findEdgeIdsInNeighborhood(point.lat, point.lon, 1, arg_0 -> ((IntHashSet)result).add(arg_0));
                    if (result.isEmpty()) {
                        throw new PointNotFoundException("Cannot find point: " + point, i);
                    }
                    IntCursor stopNodeId = (IntCursor)result.iterator().next();
                    for (Map.Entry<GtfsStorage.FeedIdWithStopId, Integer> e : this.gtfsStorage.getStationNodes().entrySet()) {
                        if (e.getValue() != stopNodeId.value) continue;
                        Stop stop = this.gtfsStorage.getGtfsFeeds().get((Object)e.getKey().feedId).stops.get(e.getKey().stopId);
                        Snap stopSnap = new Snap(stop.stop_lat, stop.stop_lon);
                        stopSnap.setClosestNode(stopNodeId.value);
                        allSnaps.add(() -> new Label.NodeId(Optional.ofNullable(this.gtfsStorage.getPtToStreet().get(stopSnap.getClosestNode())).orElse(-1), stopSnap.getClosestNode()));
                        points.add(stopSnap.getQueryPoint().lat, stopSnap.getQueryPoint().lon);
                    }
                    continue;
                }
                pointSnaps.add(snap);
                allSnaps.add(() -> new Label.NodeId(closest.getClosestNode(), Optional.ofNullable(this.gtfsStorage.getStreetToPt().get(closest.getClosestNode())).orElse(-1)));
                points.add((GHPoint)snap.getSnappedPoint());
                continue;
            }
            if (!(location instanceof GHStationLocation)) continue;
            Snap stopSnap = this.findByStopId((GHStationLocation)location, i);
            allSnaps.add(() -> new Label.NodeId(Optional.ofNullable(this.gtfsStorage.getPtToStreet().get(stopSnap.getClosestNode())).orElse(-1), stopSnap.getClosestNode()));
            points.add(stopSnap.getQueryPoint().lat, stopSnap.getQueryPoint().lon);
        }
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.baseGraph.getBaseGraph(), pointSnaps);
        ArrayList<Label.NodeId> nodes = new ArrayList<Label.NodeId>();
        for (Supplier supplier : allSnaps) {
            nodes.add((Label.NodeId)supplier.get());
        }
        return new Result(queryGraph, nodes, points);
    }

    private Snap findByStopId(GHStationLocation station, int indexForErrorMessage) {
        for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
            Integer node = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(entry.getKey(), station.stop_id));
            if (node == null) continue;
            Stop stop = this.gtfsStorage.getGtfsFeeds().get((Object)entry.getKey()).stops.get(station.stop_id);
            Snap stationSnap = new Snap(stop.stop_lat, stop.stop_lon);
            stationSnap.setClosestNode(node.intValue());
            return stationSnap;
        }
        throw new PointNotFoundException("Cannot find station: " + station.stop_id, indexForErrorMessage);
    }

    public static class Result {
        public final QueryGraph queryGraph;
        public final List<Label.NodeId> nodes;
        public final PointList points;

        public Result(QueryGraph queryGraph, List<Label.NodeId> nodes, PointList points) {
            this.queryGraph = queryGraph;
            this.nodes = nodes;
            this.points = points;
        }
    }
}

