/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.customscalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLScalarTypeDate {
    private static Logger logger = LoggerFactory.getLogger(GraphQLScalarTypeDate.class);
    public static GraphQLScalarType Date = GraphQLScalarType.newScalar().name("Date").description("Custom Scalar for Date management. It serializes dates in String, formatted as: YYYY-MM-DD.").coercing((Coercing)new Coercing<Date, String>(){
        static final String DATE_PATTERN = "yyyy-MM-dd";
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String serialize(Object input) throws CoercingSerializeException {
            if (input instanceof Date) {
                SimpleDateFormat simpleDateFormat = this.formater;
                synchronized (simpleDateFormat) {
                    return this.formater.format((Date)input);
                }
            }
            throw new CoercingSerializeException("Can't parse the '" + input.toString() + "' Date to a String (it should be a " + Date.class.getName() + " but is a " + input.getClass().getName() + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date parseValue(Object o) throws CoercingParseValueException {
            if (!(o instanceof String)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string to a Date (it should be a String but is a " + o.getClass().getName() + ")");
            }
            try {
                SimpleDateFormat simpleDateFormat = this.formater;
                synchronized (simpleDateFormat) {
                    return this.formater.parse((String)o);
                }
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date parseLiteral(Object o) throws CoercingParseLiteralException {
            String val = null;
            if (!(o instanceof StringValue)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string value to a Date (it should be a StringValue but is a " + o.getClass().getName() + ")");
            }
            try {
                val = ((StringValue)o).getValue();
                logger.trace("Parsing date from this literal: '{}'", (Object)val);
                SimpleDateFormat simpleDateFormat = this.formater;
                synchronized (simpleDateFormat) {
                    return this.formater.parse(val);
                }
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage() + " when trying to parse '" + val + "'", (Throwable)e);
            }
        }
    }).build();
}

