/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.util;

import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphqlUtils {
    private static Logger logger = LoggerFactory.getLogger(GraphqlUtils.class);
    public static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    private List<String> javaKeywords = new ArrayList<String>();
    private Properties properties;
    static final String PROPERTIES_FILE = "graphql-java-runtime.properties";
    static final String PROP_RUNTIME_VERSION = "graphql-java-runtime.version";
    public static Character JAVA_KEYWORD_PREFIX = Character.valueOf('_');

    public GraphqlUtils() {
        this.javaKeywords.add("abstract");
        this.javaKeywords.add("assert");
        this.javaKeywords.add("boolean");
        this.javaKeywords.add("break");
        this.javaKeywords.add("byte");
        this.javaKeywords.add("case");
        this.javaKeywords.add("catch");
        this.javaKeywords.add("char");
        this.javaKeywords.add("class");
        this.javaKeywords.add("const");
        this.javaKeywords.add("continue");
        this.javaKeywords.add("default");
        this.javaKeywords.add("do");
        this.javaKeywords.add("double");
        this.javaKeywords.add("else");
        this.javaKeywords.add("enum");
        this.javaKeywords.add("extends");
        this.javaKeywords.add("final");
        this.javaKeywords.add("finally");
        this.javaKeywords.add("float");
        this.javaKeywords.add("for");
        this.javaKeywords.add("goto");
        this.javaKeywords.add("if");
        this.javaKeywords.add("implements");
        this.javaKeywords.add("import");
        this.javaKeywords.add("instanceof");
        this.javaKeywords.add("int");
        this.javaKeywords.add("interface");
        this.javaKeywords.add("long");
        this.javaKeywords.add("native");
        this.javaKeywords.add("new");
        this.javaKeywords.add("null");
        this.javaKeywords.add("package");
        this.javaKeywords.add("private");
        this.javaKeywords.add("protected");
        this.javaKeywords.add("public");
        this.javaKeywords.add("return");
        this.javaKeywords.add("short");
        this.javaKeywords.add("static");
        this.javaKeywords.add("strictfp");
        this.javaKeywords.add("super");
        this.javaKeywords.add("switch");
        this.javaKeywords.add("synchronized");
        this.javaKeywords.add("this");
        this.javaKeywords.add("throw");
        this.javaKeywords.add("throws");
        this.javaKeywords.add("transient");
        this.javaKeywords.add("try");
        this.javaKeywords.add("void");
        this.javaKeywords.add("volatile");
        this.javaKeywords.add("while");
    }

    public String getRuntimeVersion() {
        return this.getProperties().getProperty(PROP_RUNTIME_VERSION);
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try (InputStream res = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
                this.properties.load(res);
            }
            catch (IOException e) {
                String msg = "Error while reading the 'graphql-java-runtime.properties' properties file: " + e.getMessage();
                logger.error(msg);
                throw new RuntimeException(msg, e);
            }
        }
        return this.properties;
    }

    public String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public String getPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public <I> List<I> iterableToList(Iterable<I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <I> List<I> iterableConcreteClassToListInterface(Iterable<? extends I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <T> T optionalToObject(Optional<T> optional) {
        return optional.isPresent() ? (T)optional.get() : null;
    }

    public <T> List<T> orderList(List<?> keys, List<T> unorderedList, String keyFieldName) {
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T t : unorderedList) {
            map.put(this.invokeGetter(t, keyFieldName), t);
        }
        ArrayList ret = new ArrayList(keys.size());
        for (Object id : keys) {
            if (map.containsKey(id)) {
                ret.add(map.get(id));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    public <T> Method getSetter(Class<T> clazz, Field field) {
        GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
        GraphQLNonScalar graphQLUnionType = field.getAnnotation(GraphQLNonScalar.class);
        String setterMethodName = graphQLUnionType != null ? "set" + this.getPascalCase(graphQLUnionType.fieldName()) : (graphQLScalar != null ? "set" + this.getPascalCase(graphQLScalar.fieldName()) : "set" + this.getPascalCase(field.getName()));
        try {
            return clazz.getDeclaredMethod(setterMethodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The setter '" + setterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the setter '" + setterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Method getSetter(Class<?> owningClass, String fieldName) {
        String setterMethodName = "set" + this.getPascalCase(fieldName);
        Method method = null;
        for (Method m : owningClass.getMethods()) {
            if (!m.getName().equals(setterMethodName)) continue;
            if (method != null) {
                throw new RuntimeException("the " + owningClass.getName() + " contains more than one method named " + setterMethodName);
            }
            method = m;
        }
        if (method == null) {
            throw new RuntimeException("the " + owningClass.getName() + " contains no method named " + setterMethodName);
        }
        return method;
    }

    public Method getGetter(Class<?> clazz, Field field) {
        GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
        GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
        String fieldName = graphQLScalar != null ? graphQLScalar.fieldName() : (graphQLNonScalar != null ? graphQLNonScalar.fieldName() : field.getName());
        String getterMethodName = "get" + this.getPascalCase(fieldName);
        try {
            Method method = null;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    getterMethodName = "is" + this.getPascalCase(fieldName);
                    method = clazz.getMethod(getterMethodName, new Class[0]);
                }
                throw e;
            }
            if (field.getType() != method.getReturnType()) {
                throw new RuntimeException("The getter '" + getterMethodName + "' and the field '" + field.getName() + "' of the class " + clazz.getName() + " should be of the same type");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The " + clazz.getName() + " class should have a getter '" + getterMethodName + "', but this getter is missing", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the getter '" + getterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Object invokeGetter(Object object, String fieldName) {
        try {
            Field field = this.getField(object, fieldName);
            Method getter = this.getGetter(object.getClass(), field);
            return getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the getter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    private Field getField(Object object, String fieldName) {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException("Could not find the field " + fieldName + " in either " + object.getClass().getName() + " or in one of its superclass");
    }

    public void invokeSetter(Object object, Field field, Object value) {
        try {
            Method setter = this.getSetter(object.getClass(), field);
            setter.invoke(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + field.getName() + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void invokeSetter(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            this.invokeSetter(object, field, value);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public Method getMethod(String methodName, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get the method '" + methodName + "' in the " + clazz.getName() + " class", e);
        }
    }

    public Object invokeMethod(String methodName, Object object, Object ... args) {
        try {
            Method getType = object.getClass().getDeclaredMethod(methodName, new Class[0]);
            return getType.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error when trying to execute '" + methodName + "' on '" + object.getClass().getName() + "': " + e.getMessage(), e);
        }
    }

    public Object invokeMethod(Method method, Object o, Object ... args) {
        try {
            return method.invoke(o, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            StringBuilder msg = new StringBuilder("Error when executing the method '");
            msg.append(method.getName());
            msg.append("(");
            String separator = "";
            for (Object arg : args) {
                msg.append(separator);
                separator = ",";
                msg.append(arg.getClass().getName());
            }
            msg.append(")'");
            if (o != null) {
                msg.append(" is missing in ");
                msg.append(o.getClass().getName());
                msg.append(" class");
            }
            throw new RuntimeException(msg.toString(), e);
        }
    }

    public Object invokeStaticMethod(String methodName, Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            return method.invoke((Object)method, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error when trying to execute the static method '" + methodName + "' on '" + clazz.getName() + "': " + e.getMessage(), e);
        }
    }

    public String getJavaName(String name) {
        return this.isJavaReservedWords(name) ? JAVA_KEYWORD_PREFIX + name : name;
    }

    public boolean isJavaReservedWords(String name) {
        return this.javaKeywords.contains(name);
    }

    public String getClassSimpleName(String classFullNameParam) {
        String classFullName = classFullNameParam.endsWith("[]") ? classFullNameParam.substring(0, classFullNameParam.length() - 2) : classFullNameParam;
        int lstPointPosition = classFullName.lastIndexOf(46);
        if (lstPointPosition > 0) {
            return classFullName.substring(lstPointPosition + 1);
        }
        if (this.isPrimitiveType(classFullName)) {
            return classFullName;
        }
        throw new IllegalArgumentException("The class full name should contain at least one point, or be a primitive type, but '" + classFullName + "' doesn't");
    }

    boolean isPrimitiveType(String type) {
        List<String> primitiveTypes = Arrays.asList("boolean", "byte", "short", "int", "long", "char", "float", "double");
        return primitiveTypes.contains(type);
    }

    public String getPackageName(String classFullNameParam) {
        String classFullName;
        String string = classFullName = classFullNameParam.endsWith("[]") ? classFullNameParam.substring(0, classFullNameParam.length() - 2) : classFullNameParam;
        if (this.isPrimitiveType(classFullName)) {
            return null;
        }
        int lstPointPosition = classFullName.lastIndexOf(46);
        return classFullName.substring(0, lstPointPosition);
    }

    @SafeVarargs
    public final <T> Stream<T> concatStreams(Class<T> clazz, boolean parallelStreams, T t1, T t2, T t3, List<? extends T> ... lists) {
        Stream.Builder<T> builder = Stream.builder();
        if (t1 != null) {
            builder.accept(t1);
        }
        if (t2 != null) {
            builder.accept(t2);
        }
        if (t3 != null) {
            builder.accept(t3);
        }
        Stream ret = builder.build();
        for (List<T> list : lists) {
            ret = Stream.concat(ret, list.stream());
        }
        return parallelStreams ? (Stream)ret.parallel() : ret;
    }

    Object getValue(Value<?> value, String graphqlTypeName, String action) {
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof ArrayValue) {
            List list = ((ArrayValue)value).getValues();
            Object[] ret = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = this.getValue((Value)list.get(i), graphqlTypeName, action + ": ArrayValue(" + i + ")");
            }
            return ret;
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed (" + action + ")");
    }

    public String getValueAsText(Value<?> value) {
        if (value == null || value instanceof NullValue) {
            return "null";
        }
        if (value instanceof StringValue) {
            return "\"" + ((StringValue)value).getValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "").replace("\t", "\\t") + "\"";
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue() ? "true" : "false";
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue().toString();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue().toString();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof ObjectValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean appendSep = false;
            for (ObjectField v : ((ObjectValue)value).getObjectFields()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(v.getName()).append(":").append(this.getValueAsText(v.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof ArrayValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean appendSep = false;
            for (Value v : ((ArrayValue)value).getValues()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(this.getValueAsText(v));
            }
            sb.append("]");
            return sb.toString();
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed");
    }

    public String getValueAsString(Value<?> value) {
        String str = this.getValueAsStringIterative(value, 0);
        if (str.startsWith("\"")) {
            return str;
        }
        return "\"" + str + "\"";
    }

    private String getValueAsStringIterative(Value<?> value, int depth) {
        if (value == null || value instanceof NullValue) {
            return "null";
        }
        if (value instanceof StringValue) {
            return "\"" + ((StringValue)value).getValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "").replace("\t", "\\t") + "\"";
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue() ? "true" : "false";
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue().toString();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue().toString();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof ObjectValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean appendSep = false;
            for (ObjectField v : ((ObjectValue)value).getObjectFields()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(v.getName()).append(":").append(this.getValueAsStringIterative(v.getValue(), depth + 1));
            }
            sb.append("}");
            if (depth == 0) {
                return "\"" + sb.toString().replace("\"", "\\\"") + "\"";
            }
            return sb.toString();
        }
        if (value instanceof ArrayValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean appendSep = false;
            for (Value v : ((ArrayValue)value).getValues()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(this.getValueAsStringIterative(v, depth + 1));
            }
            sb.append("]");
            if (depth == 0) {
                return "\"" + sb.toString().replace("\"", "\\\"") + "\"";
            }
            return sb.toString();
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed");
    }

    public Object stringToEnumValue(Object enumValue, Class<?> enumClass) {
        if (enumValue == null) {
            return null;
        }
        if (enumValue instanceof List) {
            return ((List)enumValue).stream().map(v -> this.stringToEnumValue(v, enumClass)).collect(Collectors.toList());
        }
        if (enumValue instanceof String) {
            Method method;
            try {
                method = enumClass.getMethod("fromGraphQlValue", String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Could not find the 'fromGraphQlValue' method to bind the '" + enumValue + "' value to the " + enumClass.getName() + " class");
            }
            try {
                return method.invoke(null, enumValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Error when binding the '" + enumValue + "' value to the " + enumClass.getName() + " class: " + e.getMessage());
            }
        }
        throw new RuntimeException("Non managed type when trying to bind the '" + enumValue + "' value to the " + enumClass.getName() + " class");
    }

    public Long getLastModified(File fileOrFolder, boolean maxValue) {
        if (fileOrFolder == null || !fileOrFolder.exists()) {
            return null;
        }
        if (fileOrFolder.isFile()) {
            return fileOrFolder.lastModified();
        }
        if (fileOrFolder.isDirectory()) {
            Long lastModifed = null;
            for (File f : fileOrFolder.listFiles()) {
                Long contentLastModified = this.getLastModified(f, maxValue);
                if (contentLastModified == null) continue;
                if (lastModifed == null) {
                    lastModifed = contentLastModified;
                    continue;
                }
                if (maxValue && contentLastModified > lastModifed) {
                    lastModifed = contentLastModified;
                    continue;
                }
                if (maxValue || contentLastModified >= lastModifed) continue;
                lastModifed = contentLastModified;
            }
            return lastModifed;
        }
        throw new RuntimeException("Non managed file type for " + fileOrFolder.getAbsolutePath());
    }

    public String getQuotedScanBasePackages(String scanBasePackages) {
        if (scanBasePackages == null || ((String)scanBasePackages).contentEquals("") || ((String)scanBasePackages).contentEquals("null")) {
            return "";
        }
        scanBasePackages = ((String)scanBasePackages).replace(" ", "");
        scanBasePackages = ((String)scanBasePackages).replace(",", "\",\"");
        scanBasePackages = ",\"" + (String)scanBasePackages + "\"";
        return scanBasePackages;
    }
}

