/*
 * Decompiled with CFR 0.152.
 */
package graphql.java.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.java.client.QueryExecutor;
import graphql.java.client.request.InputParameter;
import graphql.java.client.request.ObjectResponse;
import graphql.java.client.response.Error;
import graphql.java.client.response.GraphQLExecutionException;
import graphql.java.client.response.GraphQLResponseParseException;
import graphql.java.client.response.JsonResponseWrapper;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryExecutorImpl
implements QueryExecutor {
    private static Logger logger = LogManager.getLogger();
    Client client;
    WebTarget webTarget;

    public QueryExecutorImpl(String graphqlEndpoint) {
        if (graphqlEndpoint.startsWith("https:")) {
            throw new IllegalArgumentException("This GraphQL endpoint is an https one. Please provide the SSLContext and HostnameVerifier items, by using the relevant Query/Mutation/Subscription constructor");
        }
        this.client = ClientBuilder.newClient();
        this.webTarget = this.client.target(graphqlEndpoint);
    }

    public QueryExecutorImpl(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (graphqlEndpoint.startsWith("http:")) {
            throw new IllegalArgumentException("This GraphQL endpoint is an http one. Please use the relevant Query/Mutation/Subscription constructor (without the SSLContext and HostnameVerifier parameters)");
        }
        this.client = ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(hostnameVerifier).build();
        this.webTarget = this.client.target(graphqlEndpoint);
    }

    @Override
    public <T> T execute(String requestType, ObjectResponse objectResponse, List<InputParameter> parameters, Class<T> valueType) throws GraphQLExecutionException {
        String request = null;
        try {
            request = this.buildRequest(requestType, objectResponse, parameters);
            logger.trace(GRAPHQL_MARKER, "Generated GraphQL request: {}", (Object)request);
            return this.doJsonRequestExecution(request, valueType);
        }
        catch (IOException e) {
            throw new GraphQLExecutionException("Error when executing query <" + request + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T execute(String query, Class<T> valueType) throws IOException, GraphQLExecutionException {
        return this.doJsonRequestExecution(query, valueType);
    }

    <T> T doJsonRequestExecution(String jsonRequest, Class<T> valueType) throws IOException, GraphQLExecutionException {
        Invocation.Builder invocationBuilder = this.webTarget.request(new String[]{"application/json"});
        invocationBuilder.header("Accept", (Object)"application/json");
        JsonResponseWrapper response = (JsonResponseWrapper)invocationBuilder.post(Entity.entity((Object)jsonRequest, (String)"application/json"), JsonResponseWrapper.class);
        if (logger.isTraceEnabled()) {
            ObjectMapper objectMapper = new ObjectMapper();
            logger.trace("Parsed response data: {}", (Object)objectMapper.writeValueAsString((Object)response.data));
            logger.trace("Parsed response errors: {}", (Object)objectMapper.writeValueAsString(response.errors));
        }
        if (response.errors == null || response.errors.size() == 0) {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.treeToValue((TreeNode)response.data, valueType);
        }
        int nbErrors = 0;
        String agregatedMessage = null;
        for (Error error : response.errors) {
            String msg = error.toString();
            ++nbErrors;
            logger.error(GRAPHQL_MARKER, msg);
            if (agregatedMessage == null) {
                agregatedMessage = msg;
                continue;
            }
            agregatedMessage = agregatedMessage + ", ";
            agregatedMessage = agregatedMessage + msg;
        }
        if (nbErrors == 0) {
            throw new GraphQLExecutionException("An unknown error occured");
        }
        throw new GraphQLExecutionException(nbErrors + " errors occured: " + agregatedMessage);
    }

    String buildRequest(String requestType, ObjectResponse objectResponse, List<InputParameter> parameters) {
        if (!(requestType.equals("query") || requestType.equals("mutation") || requestType.equals("subscription"))) {
            throw new IllegalArgumentException("requestType must be one of \"query\", \"mutation\" or \"subscription\", but is \"" + requestType + "\"");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(requestType).append(" ");
        sb.append("{");
        sb.append(objectResponse.getFieldName());
        if (parameters != null && parameters.size() > 0) {
            sb.append("(");
            boolean writeComma = false;
            for (InputParameter param : parameters) {
                if (writeComma) {
                    sb.append(", ");
                }
                writeComma = true;
                sb.append(param.getName()).append(": ").append(param.getValueForGraphqlQuery());
            }
            sb.append(")");
        }
        objectResponse.appendResponseQuery(sb);
        sb.append("}");
        return "{\"query\":\"" + sb.toString() + "\",\"variables\":null,\"operationName\":null}";
    }

    <T> T parseResponse(String rawResponse, ObjectResponse objectResponse, Class<T> valueType) throws GraphQLResponseParseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(rawResponse);
        if (node.size() != 1) {
            throw new GraphQLResponseParseException("The response should contain one root element, but it contains " + node.size() + " elements");
        }
        JsonNode data = node.get("data");
        if (data == null) {
            throw new GraphQLResponseParseException("Could not retrieve the 'data' node");
        }
        JsonNode hero = data.get("hero");
        if (hero == null) {
            throw new GraphQLResponseParseException("Could not retrieve the 'hero' node");
        }
        return (T)mapper.treeToValue((TreeNode)hero, valueType);
    }
}

