/*
 * Decompiled with CFR 0.152.
 */
package graphql.java.client.request;

import graphql.java.annotation.GraphQLScalar;
import graphql.java.client.GraphqlUtils;
import graphql.java.client.request.ObjectResponse;
import graphql.java.client.response.GraphQLRequestPreparationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Builder {
    GraphqlUtils graphqlUtils = new GraphqlUtils();
    final ObjectResponse objectResponse;

    Builder(Class<?> objectClass) {
        this.objectResponse = new ObjectResponse(objectClass);
    }

    public Builder withField(String fieldName) throws GraphQLRequestPreparationException {
        return this.withField(fieldName, null);
    }

    public Builder withField(String fieldName, String alias) throws GraphQLRequestPreparationException {
        this.graphqlUtils.checkFieldOfGraphQLType(fieldName, true, this.objectResponse.fieldClass);
        for (ObjectResponse.Field field : this.objectResponse.scalarFields) {
            if (!field.name.equals(fieldName)) continue;
            throw new GraphQLRequestPreparationException("The field <" + fieldName + "> is already in the field list for the objet <" + this.objectResponse.fieldName + ">");
        }
        this.objectResponse.scalarFields.add(new ObjectResponse.Field(fieldName, alias));
        return this;
    }

    public Builder withSubObject(String fieldName, ObjectResponse objectResponse) throws GraphQLRequestPreparationException {
        return this.withSubObject(fieldName, null, objectResponse);
    }

    public Builder withSubObject(String fieldName, String fieldAlias, ObjectResponse subobjetResponseDef) throws GraphQLRequestPreparationException {
        Class<?> subObjetClass = this.graphqlUtils.checkFieldOfGraphQLType(fieldName, false, this.objectResponse.fieldClass);
        if (!subObjetClass.equals(subobjetResponseDef.fieldClass)) {
            throw new GraphQLRequestPreparationException("Error creating subobject: the given field <" + fieldName + "> is of type " + subObjetClass.getName() + ", but the given ObjetResponseDef is of type " + subobjetResponseDef.fieldClass.getName());
        }
        for (ObjectResponse subObject : this.objectResponse.subObjects) {
            if (!subObject.fieldName.equals(fieldName)) continue;
            throw new GraphQLRequestPreparationException("The field <" + subObject.fieldName + "> is already in the field list for the objet <" + this.objectResponse.fieldName + ">");
        }
        subobjetResponseDef.setOwningClass(this.objectResponse.fieldClass);
        subobjetResponseDef.setField(fieldName, fieldAlias);
        this.objectResponse.subObjects.add(subobjetResponseDef);
        return this;
    }

    public ObjectResponse build() throws GraphQLRequestPreparationException {
        if (this.objectResponse.scalarFields.size() == 0 && this.objectResponse.subObjects.size() == 0) {
            this.addKnownScalarFields();
        }
        return this.objectResponse;
    }

    public Builder withQueryResponseDef(String queryResponseDef) throws GraphQLRequestPreparationException {
        if (queryResponseDef == null || queryResponseDef.trim().equals("")) {
            this.addKnownScalarFields();
        } else {
            StringTokenizer st = new StringTokenizer(queryResponseDef, " {}:()", true);
            String token = " ";
            while (token.equals(" ")) {
                token = st.nextToken();
            }
            if (!token.equals("{")) {
                throw new GraphQLRequestPreparationException("The queryResponseDef should start with '{'");
            }
            QueryField queryField = new QueryField(this.objectResponse.fieldName);
            try {
                queryField.readTokenizer(st);
            }
            catch (GraphQLRequestPreparationException e) {
                throw new GraphQLRequestPreparationException(e.getMessage() + " while reading the queryReponseDef: " + queryResponseDef, e);
            }
            block9: while (st.hasMoreTokens()) {
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block9;
                    }
                }
                throw new GraphQLRequestPreparationException("Unexpected token <" + token + "> at the end of the queryReponseDef: " + queryResponseDef);
            }
            this.withQueryField(queryField);
        }
        return this;
    }

    private void addKnownScalarFields() throws GraphQLRequestPreparationException {
        if (this.objectResponse.getFieldClass().isInterface()) {
            for (Method method : this.objectResponse.getFieldClass().getDeclaredMethods()) {
                GraphQLScalar annotation;
                if (!method.getName().startsWith("get") || (annotation = method.getAnnotation(GraphQLScalar.class)) == null) continue;
                this.withField(Builder.getCamelCase(method.getName().substring(3)));
            }
        } else {
            for (Field attribute : this.objectResponse.getFieldClass().getDeclaredFields()) {
                GraphQLScalar annotation = attribute.getAnnotation(GraphQLScalar.class);
                if (annotation == null) continue;
                this.withField(Builder.getCamelCase(attribute.getName()));
            }
        }
    }

    public static String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private Builder withQueryField(QueryField queryField) throws GraphQLRequestPreparationException {
        if (!queryField.name.equals(this.objectResponse.getFieldName())) {
            throw new GraphQLRequestPreparationException("[INTERNAL ERROR] the field name of the queryField is <" + queryField.name + "> whereas the field name of the objetResponseDef is <" + this.objectResponse.getFieldName() + ">");
        }
        for (QueryField field : queryField.fields) {
            if (field.fields.size() == 0) {
                this.withField(field.name, field.alias);
                continue;
            }
            ObjectResponse subobjectResponseDef = ObjectResponse.newQueryResponseDefBuilder(this.objectResponse.fieldClass, field.name, field.alias).withQueryField(field).build();
            this.withSubObject(field.name, field.alias, subobjectResponseDef);
        }
        return this;
    }

    class QueryField {
        String name;
        String alias;
        List<QueryField> fields = new ArrayList<QueryField>();

        QueryField(String name) {
            this.name = name;
        }

        public void readTokenizer(StringTokenizer st) throws GraphQLRequestPreparationException {
            QueryField lastReadField = null;
            block14: while (st.hasMoreTokens()) {
                String token;
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block14;
                    }
                    case ":": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has a ':' character, not preceded by a proper alias name (before <" + st.nextToken() + ">)");
                        }
                        lastReadField.alias = lastReadField.name;
                        lastReadField.name = " ";
                        while (lastReadField.name.equals(" ")) {
                            lastReadField.name = st.nextToken();
                        }
                        continue block14;
                    }
                    case "(": {
                        throw new GraphQLRequestPreparationException("The given query contains a '(' (parenthesis), field parameters are not managed yet");
                    }
                    case "{": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has two '{', one after another (error while reading field <" + this.name + ">) while reading <" + this.name + ">");
                        }
                        if (lastReadField.fields.size() > 0) {
                            throw new GraphQLRequestPreparationException("The given query contains a '{' not preceded by a fieldname, after field <" + lastReadField.name + "> while reading <" + this.name + ">");
                        }
                        lastReadField.readTokenizer(st);
                        lastReadField = null;
                        continue block14;
                    }
                    case "}": {
                        return;
                    }
                }
                lastReadField = new QueryField(token);
                this.fields.add(lastReadField);
            }
            throw new GraphQLRequestPreparationException("The field <" + this.name + "> has a non finished list of fields (it lacks the finishing '}') while reading <" + this.name + ">");
        }
    }
}

