/*
 * Decompiled with CFR 0.152.
 */
package graphql.java.client.request;

import graphql.java.client.GraphqlUtils;
import graphql.java.client.QueryExecutor;
import graphql.java.client.request.Builder;
import graphql.java.client.response.GraphQLRequestPreparationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public class ObjectResponse {
    private static Logger logger = LogManager.getLogger();
    static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Marker marker = QueryExecutor.GRAPHQL_MARKER;
    Class<?> owningClass;
    String fieldName;
    Class<?> fieldClass;
    String fieldAlias;
    List<Field> scalarFields = new ArrayList<Field>();
    List<ObjectResponse> subObjects = new ArrayList<ObjectResponse>();

    ObjectResponse(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }

    public static Builder newQueryResponseDefBuilder(Class<?> clazz, String fieldName) throws GraphQLRequestPreparationException {
        return ObjectResponse.newQueryResponseDefBuilder(clazz, fieldName, null);
    }

    public static Builder newQueryResponseDefBuilder(Class<?> clazz, String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        Builder ret = new Builder(clazz);
        ret.objectResponse.setOwningClass(clazz);
        ret.objectResponse.setField(fieldName, fieldAlias);
        return ret;
    }

    public static Builder newSubObjectBuilder(Class<?> clazz) {
        return new Builder(clazz);
    }

    void setOwningClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("The owningClass of an " + this.getClass().getName() + " may not be null");
        }
        this.owningClass = clazz;
    }

    void setField(String fieldName) throws GraphQLRequestPreparationException {
        this.setField(fieldName, null);
    }

    void setField(String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        Class<?> clazz = graphqlUtils.checkFieldOfGraphQLType(fieldName, false, this.owningClass);
        if (fieldAlias != null) {
            graphqlUtils.checkName(fieldAlias);
        }
        this.fieldName = fieldName;
        this.fieldAlias = fieldAlias;
        this.fieldClass = clazz;
    }

    public String getFieldAlias() {
        return this.fieldAlias;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void appendResponseQuery(StringBuilder sb) {
        if (this.scalarFields.size() > 0 || this.subObjects.size() > 0) {
            logger.debug("Appending ReponseDef content for field " + this.fieldName + " of type " + this.fieldClass);
            sb.append("{");
            this.scalarFields.stream().forEach(f -> this.appendFieldName(sb, f.name, f.alias));
            for (ObjectResponse o : this.subObjects) {
                this.appendFieldName(sb, o.fieldName, o.fieldAlias);
                o.appendResponseQuery(sb);
            }
            sb.append("}");
        }
    }

    void appendFieldName(StringBuilder sb, String name, String alias) {
        sb.append(" ");
        if (alias != null) {
            sb.append(alias).append(": ");
        }
        sb.append(name);
    }

    static class Field {
        final String name;
        final String alias;

        Field(String name, String alias) throws GraphQLRequestPreparationException {
            graphqlUtils.checkName(name);
            if (alias != null) {
                graphqlUtils.checkName(alias);
            }
            this.name = name;
            this.alias = alias;
        }
    }
}

