/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLInputParameters;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;

public class InputParameter {
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    private static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final String name;
    final String bindParameterName;
    final Object value;
    final boolean mandatory;
    final GraphQLScalarType graphQLCustomScalarType;

    public static InputParameter newBindParameter(String name, String bindParameterName, boolean mandatory) {
        if (bindParameterName == null) {
            throw new NullPointerException("[Internal error] The bindParameterName is mandatory");
        }
        return InputParameter.newBindParameter(name, bindParameterName, mandatory, null);
    }

    public static InputParameter newBindParameter(String name, String bindParameterName, boolean mandatory, GraphQLScalarType graphQLScalarType) {
        if (bindParameterName == null) {
            throw new NullPointerException("[Internal error] The bindParameterName is mandatory");
        }
        return new InputParameter(name, bindParameterName, null, mandatory, graphQLScalarType);
    }

    public static InputParameter newHardCodedParameter(String name, Object value) {
        return new InputParameter(name, null, value, true, null);
    }

    public static InputParameter newHardCodedParameter(String name, Object value, boolean mandatory, GraphQLScalarType type) {
        return new InputParameter(name, null, value, mandatory, type);
    }

    private InputParameter(String name, String bindParameterName, Object value, boolean mandatory, GraphQLScalarType graphQLCustomScalarType) {
        if (name == null) {
            throw new NullPointerException("The input parameter's name is mandatory");
        }
        this.name = name;
        this.bindParameterName = bindParameterName;
        this.value = value;
        this.mandatory = mandatory;
        this.graphQLCustomScalarType = graphQLCustomScalarType;
    }

    public static List<InputParameter> readTokenizerForInputParameters(QueryTokenizer qt, Directive directive, Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        ArrayList<InputParameter> ret = new ArrayList<InputParameter>();
        InputParameterStep step = InputParameterStep.NAME;
        String parameterName = null;
        block17: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case ":": {
                    continue block17;
                }
                case "[": 
                case "{": {
                    throw new GraphQLRequestPreparationException("Encountered a '" + token + "' while reading parameters for the field '" + fieldName + "' : if this is an input type as a parameter value, please use bind variable instead. For instance: \"" + parameterName + ":?" + parameterName + "Param\", and provide a value for the " + parameterName + "Param bind parameter (please check the graphql-maven-plugin-project.graphql-java-generator.com site for more information on how to 'Execute GraphQL requests')");
                }
                case ",": {
                    if (step == InputParameterStep.NAME) continue block17;
                    throw new GraphQLRequestPreparationException("Misplaced comma for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                }
                case ")": {
                    if (parameterName == null) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' (no parameter has been read)");
                    }
                    if (step != InputParameterStep.NAME) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                    }
                    return ret;
                }
            }
            switch (step) {
                case NAME: {
                    parameterName = token;
                    step = InputParameterStep.VALUE;
                    break;
                }
                case VALUE: {
                    if (token.startsWith("?")) {
                        ret.add(new InputParameter(parameterName, token.substring(1), null, false, graphqlClientUtils.getGraphQLType(directive, owningClass, fieldName, parameterName)));
                    } else if (token.startsWith("&")) {
                        ret.add(new InputParameter(parameterName, token.substring(1), null, true, graphqlClientUtils.getGraphQLType(directive, owningClass, fieldName, parameterName)));
                    } else if (token.equals("\"")) {
                        StringBuffer sb = new StringBuffer();
                        while (true) {
                            if (!qt.hasMoreTokens(true)) {
                                throw new GraphQLRequestPreparationException("Found the end of string before the end of the string parameter '" + sb.toString() + "'");
                            }
                            token = qt.nextToken(true);
                            if (token.contentEquals("\"")) break;
                            sb.append(token);
                            if (!token.equals("\\")) continue;
                            sb.append(qt.nextToken(true));
                        }
                        ret.add(new InputParameter(parameterName, null, sb.toString(), true, null));
                    } else {
                        Object parameterValue;
                        if (token.startsWith("\"") || token.endsWith("\"")) {
                            throw new GraphQLRequestPreparationException("Bad parameter value: parameter values should start and finish by \", or not having any \" at the beginning and end. But it's not the case for the value <" + token + "> of parameter <" + parameterName + ">. Maybe you wanted to add a bind parameter instead (bind parameter must start with a ? or a &");
                        }
                        if (directive != null) {
                            parameterValue = InputParameter.parseDirectiveArgumentValue(directive, parameterName, token);
                            InputParameter arg = new InputParameter(parameterName, null, parameterValue, true, null);
                            ret.add(arg);
                            directive.getArguments().add(arg);
                        } else {
                            parameterValue = InputParameter.parseInputParameterValue(owningClass, fieldName, parameterName, token);
                            ret.add(new InputParameter(parameterName, null, parameterValue, true, null));
                        }
                    }
                    step = InputParameterStep.NAME;
                }
            }
        }
        throw new GraphQLRequestPreparationException("The list of parameters for the field '" + fieldName + "' is not finished (no closing parenthesis)");
    }

    private static Object parseInputParameterValue(Class<?> owningClass, String fieldName, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Field field = graphqlUtils.getDeclaredField(owningClass, graphqlUtils.getJavaName(fieldName), true);
        GraphQLInputParameters graphQLInputParameters = field.getDeclaredAnnotation(GraphQLInputParameters.class);
        if (graphQLInputParameters == null) {
            throw new GraphQLRequestPreparationException("[Internal error] The field '" + fieldName + "' is lacking the GraphQLInputParameters annotation");
        }
        for (int i = 0; i < graphQLInputParameters.names().length; ++i) {
            if (!graphQLInputParameters.names()[i].equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(parameterValue, graphQLInputParameters.types()[i], owningClass.getPackage().getName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the field '" + fieldName + "' of the type '" + owningClass.getName() + "'");
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the type for the parameter '" + parameterName + "' of the field '" + fieldName + "'");
    }

    private static Object parseDirectiveArgumentValue(Directive directive, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Directive directiveDefinition = directive.getDirectiveDefinition();
        for (InputParameter param : directiveDefinition.getArguments()) {
            if (!param.getName().equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(parameterValue, param.getGraphQLScalarType().getName(), directive.getPackageName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the directive '" + directive.getName() + "'", e);
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the argument '" + parameterName + "' of the directive '" + directive.getName() + "'");
    }

    private static Object parseValueForInputParameter(String parameterValue, String parameterType, String packageName) throws GraphQLRequestPreparationException {
        try {
            return graphqlUtils.parseValueForInputParameter(parameterValue, parameterType, graphqlUtils.getClass(packageName, parameterType));
        }
        catch (RuntimeException e) {
            throw new GraphQLRequestPreparationException(e.getMessage(), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueForGraphqlQuery(Map<String, Object> bindVariables) throws GraphQLRequestExecutionException {
        if (this.bindParameterName == null) {
            return this.getValueForGraphqlQuery(this.value, this.graphQLCustomScalarType);
        }
        if (this.mandatory && (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName))) {
            throw new GraphQLRequestExecutionException("The Bind Parameter for '" + this.bindParameterName + "' must be provided in the BindVariables map");
        }
        if (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName)) {
            return null;
        }
        return this.getValueForGraphqlQuery(bindVariables.get(this.bindParameterName), this.graphQLCustomScalarType);
    }

    String getValueForGraphqlQuery(Object val, GraphQLScalarType graphQLScalarType) throws GraphQLRequestExecutionException {
        if (val == null) {
            return null;
        }
        if (val instanceof List) {
            return this.getListValue((List)val, graphQLScalarType);
        }
        if (graphQLScalarType != null) {
            Object ret = graphQLScalarType.getCoercing().serialize(val);
            if (ret instanceof String) {
                return this.getStringValue((String)ret);
            }
            return ret.toString();
        }
        if (val instanceof String) {
            return this.getStringValue((String)val);
        }
        if (val instanceof UUID) {
            return this.getStringValue(((UUID)val).toString());
        }
        if (val.getClass().getAnnotation(GraphQLInputType.class) != null) {
            return this.getInputTypeStringValue(val);
        }
        return val.toString();
    }

    private String getStringValue(String str) {
        return "\\\"" + StringEscapeUtils.escapeJson((String)StringEscapeUtils.escapeJson((String)str)) + "\\\"";
    }

    private String getListValue(List<?> list, GraphQLScalarType graphQLScalarType) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < list.size(); ++index) {
            Object obj = list.get(index);
            result.append(this.getValueForGraphqlQuery(obj, graphQLScalarType));
            if (index >= list.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }

    private String getInputTypeStringValue(Object object) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("{");
        String separator = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            Object val;
            if (field.isSynthetic() || (val = graphqlUtils.invokeGetter(object, field.getName())) == null) continue;
            result.append(separator);
            result.append(field.getName());
            result.append(":");
            result.append(this.getValueForGraphqlQuery(val, graphqlClientUtils.getGraphQLCustomScalarType(field)));
            separator = ",";
        }
        return result.append("}").toString();
    }

    public String getBindParameterName() {
        return this.bindParameterName;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public GraphQLScalarType getGraphQLScalarType() {
        return this.graphQLCustomScalarType;
    }

    public static void appendInputParametersToGraphQLRequests(StringBuilder sb, List<InputParameter> inputParameters, Map<String, Object> parameters) throws GraphQLRequestExecutionException {
        if (inputParameters != null && inputParameters.size() > 0) {
            ArrayList<String> params = new ArrayList<String>();
            for (InputParameter param : inputParameters) {
                String stringValue = param.getValueForGraphqlQuery(parameters);
                if (stringValue == null) continue;
                params.add(param.getName() + ":" + stringValue);
            }
            if (params.size() > 0) {
                sb.append("(");
                boolean writeComma = false;
                for (String param : params) {
                    if (writeComma) {
                        sb.append(",");
                    }
                    writeComma = true;
                    sb.append(param);
                }
                sb.append(")");
            }
        }
    }

    private static enum InputParameterStep {
        NAME,
        VALUE;

    }
}

