/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.CustomScalarRegistryImpl;
import com.graphql_java_generator.GraphqlUtils;
import com.graphql_java_generator.annotation.GraphQLCustomScalar;
import com.graphql_java_generator.annotation.GraphQLInputParameters;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Builder {
    private static final String STRING_TOKENIZER_DELIMITER = " {},:()";
    GraphqlUtils graphqlUtils = new GraphqlUtils();
    GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final ObjectResponse objectResponse;

    public Builder(Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        this.objectResponse = new ObjectResponse(owningClass, fieldName, null);
    }

    public Builder(Class<?> owningClass, String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        this.objectResponse = new ObjectResponse(owningClass, fieldName, fieldAlias);
    }

    public Builder withField(String fieldName) throws GraphQLRequestPreparationException {
        return this.withField(fieldName, null);
    }

    public Builder withField(String fieldName, String alias) throws GraphQLRequestPreparationException {
        return this.withField(fieldName, alias, null);
    }

    public Builder withField(String fieldName, String alias, List<InputParameter> inputParameters) throws GraphQLRequestPreparationException {
        this.graphqlClientUtils.checkFieldOfGraphQLType(fieldName, true, this.objectResponse.field.clazz);
        for (ObjectResponse.Field field : this.objectResponse.scalarFields) {
            if (!field.name.equals(fieldName)) continue;
            throw new GraphQLRequestPreparationException("The field <" + fieldName + "> is already in the field list for the objet <" + this.objectResponse.field.name + ">");
        }
        ObjectResponse.Field field = new ObjectResponse.Field(fieldName, alias, this.objectResponse.field.clazz, this.graphqlClientUtils.checkFieldOfGraphQLType(fieldName, true, this.objectResponse.field.clazz), inputParameters);
        this.objectResponse.scalarFields.add(field);
        return this;
    }

    @Deprecated
    public Builder withInputParameter(InputParameter inputParameter) {
        this.objectResponse.addInputParameter(inputParameter);
        return this;
    }

    public Builder withInputParameterHardCoded(String name, Object value) {
        this.objectResponse.addInputParameter(new InputParameter(name, null, value, true, null));
        return this;
    }

    public Builder withInputParameter(String name, String bindParameterName, boolean mandatory) throws GraphQLRequestPreparationException {
        GraphQLScalarType graphQLScalarType = this.getCustomScalarGraphQLType(this.objectResponse.getOwningClass(), this.objectResponse.getFieldName(), name);
        this.objectResponse.addInputParameter(new InputParameter(name, bindParameterName, null, mandatory, graphQLScalarType));
        return this;
    }

    public Builder withInputParameters(List<InputParameter> inputParameters) {
        this.objectResponse.addInputParameters(inputParameters);
        return this;
    }

    public Builder withSubObject(ObjectResponse subobjetResponseDef) throws GraphQLRequestPreparationException {
        if (subobjetResponseDef.field.owningClass != this.objectResponse.getFieldClass()) {
            throw new GraphQLRequestPreparationException("Class mismatch when trying to add the Field '" + subobjetResponseDef.getFieldName() + "' owned by the class '" + subobjetResponseDef.getOwningClass().getName() + "' to the field '" + this.objectResponse.getFieldName() + "' of class '" + this.objectResponse.getFieldClass().getName() + "' (the two classes should be identical)");
        }
        for (ObjectResponse subObject : this.objectResponse.subObjects) {
            if (!subObject.field.name.equals(subobjetResponseDef.getFieldName())) continue;
            throw new GraphQLRequestPreparationException("The field <" + subObject.field.name + "> is already in the field list for the objet <" + this.objectResponse.field.name + ">");
        }
        this.objectResponse.subObjects.add(subobjetResponseDef);
        return this;
    }

    public ObjectResponse build() throws GraphQLRequestPreparationException {
        if (this.objectResponse.scalarFields.size() == 0 && this.objectResponse.subObjects.size() == 0) {
            this.addKnownScalarFields();
        }
        return this.objectResponse;
    }

    public Builder withQueryResponseDef(String queryResponseDef) throws GraphQLRequestPreparationException {
        if (queryResponseDef == null || queryResponseDef.trim().equals("")) {
            this.addKnownScalarFields();
        } else {
            StringTokenizer st = new StringTokenizer(queryResponseDef, STRING_TOKENIZER_DELIMITER, true);
            String token = " ";
            while (token.equals(" ")) {
                token = st.nextToken();
            }
            if (!token.equals("{")) {
                throw new GraphQLRequestPreparationException("The queryResponseDef should start with '{'");
            }
            QueryField queryField = new QueryField(this.objectResponse.field.owningClass, this.objectResponse.field.clazz, this.objectResponse.field.name);
            try {
                queryField.readTokenizerForResponseDefinition(st);
            }
            catch (GraphQLRequestPreparationException e) {
                throw new GraphQLRequestPreparationException(e.getMessage() + " while reading the queryReponseDef: " + queryResponseDef, e);
            }
            block9: while (st.hasMoreTokens()) {
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block9;
                    }
                }
                throw new GraphQLRequestPreparationException("Unexpected token <" + token + "> at the end of the queryReponseDef: " + queryResponseDef);
            }
            this.withQueryField(queryField);
        }
        return this;
    }

    private void addKnownScalarFields() throws GraphQLRequestPreparationException {
        if (this.objectResponse.getFieldClass().isInterface()) {
            for (Method method : this.objectResponse.getFieldClass().getDeclaredMethods()) {
                GraphQLScalar annotation;
                if (!method.getName().startsWith("get") || (annotation = method.getAnnotation(GraphQLScalar.class)) == null) continue;
                this.withField(Builder.getCamelCase(method.getName().substring(3)));
            }
        } else {
            for (Field attribute : this.objectResponse.getFieldClass().getDeclaredFields()) {
                GraphQLScalar annotation = attribute.getAnnotation(GraphQLScalar.class);
                if (annotation == null) continue;
                this.withField(Builder.getCamelCase(attribute.getName()));
            }
        }
    }

    public static String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private Builder withQueryField(QueryField queryField) throws GraphQLRequestPreparationException {
        if (!queryField.name.equals(this.objectResponse.getFieldName())) {
            throw new GraphQLRequestPreparationException("[INTERNAL ERROR] the field name of the queryField is <" + queryField.name + "> whereas the field name of the objetResponseDef is <" + this.objectResponse.getFieldName() + ">");
        }
        for (QueryField field : queryField.fields) {
            if (field.fields.size() == 0) {
                this.withField(field.name, field.alias, field.inputParameters);
                continue;
            }
            Builder subobjectResponseDef = new Builder(this.objectResponse.field.clazz, field.name, field.alias).withQueryField(field).withInputParameters(field.inputParameters);
            this.withSubObject(subobjectResponseDef.build());
        }
        return this;
    }

    private GraphQLScalarType getCustomScalarGraphQLType(Class<?> owningClass, String fieldName, String parameterName) throws GraphQLRequestPreparationException {
        Field field;
        try {
            field = owningClass.getDeclaredField(this.graphqlUtils.getJavaName(fieldName));
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
        }
        GraphQLInputParameters inputParams = field.getAnnotation(GraphQLInputParameters.class);
        if (inputParams == null) {
            throw new GraphQLRequestPreparationException("The field '" + fieldName + "' of the class '" + owningClass.getName() + "' has no input parameters. Error while looking for its '" + parameterName + "' input parameter");
        }
        for (int i = 0; i < inputParams.names().length; ++i) {
            if (!inputParams.names()[i].equals(parameterName)) continue;
            String typeName = inputParams.types()[i];
            return CustomScalarRegistryImpl.customScalarRegistry.getGraphQLScalarType(typeName);
        }
        throw new GraphQLRequestPreparationException("The parameter of name '" + parameterName + "' has not been found for the field '" + fieldName + "' of the class '" + owningClass.getName() + "'");
    }

    class QueryField {
        Class<?> owningClazz;
        Class<?> clazz;
        String name;
        String alias = null;
        List<InputParameter> inputParameters = new ArrayList<InputParameter>();
        List<QueryField> fields = new ArrayList<QueryField>();

        QueryField(Class<?> owningClazz, Class<?> clazz, String name) throws GraphQLRequestPreparationException {
            this.owningClazz = owningClazz;
            this.clazz = clazz;
            this.name = name;
        }

        public void readTokenizerForResponseDefinition(StringTokenizer st) throws GraphQLRequestPreparationException {
            QueryField lastReadField = null;
            block14: while (st.hasMoreTokens()) {
                String token;
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block14;
                    }
                    case ":": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has a ':' character, not preceded by a proper alias name (before <" + st.nextToken() + ">)");
                        }
                        lastReadField.alias = lastReadField.name;
                        lastReadField.name = " ";
                        while (lastReadField.name.equals(" ")) {
                            lastReadField.name = st.nextToken();
                        }
                        lastReadField.owningClazz = this.clazz;
                        lastReadField.clazz = this.getFieldType(this.clazz, lastReadField.name, true);
                        continue block14;
                    }
                    case "(": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has a parentesis '(' not preceded by a field name (error while reading field <" + this.name + ">");
                        }
                        lastReadField.readTokenizerForInputParameters(st);
                        continue block14;
                    }
                    case "{": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has two '{', one after another (error while reading field <" + this.name + ">)");
                        }
                        if (lastReadField.clazz == null) {
                            throw new GraphQLRequestPreparationException("Starting reading definition of field '" + lastReadField.name + "' of class '" + this.owningClazz.getName() + "', but the owningClass is not set");
                        }
                        if (lastReadField.fields.size() > 0) {
                            throw new GraphQLRequestPreparationException("The given query contains a '{' not preceded by a fieldname, after field <" + lastReadField.name + "> while reading <" + this.name + ">");
                        }
                        lastReadField.readTokenizerForResponseDefinition(st);
                        lastReadField = null;
                        continue block14;
                    }
                    case "}": {
                        return;
                    }
                }
                lastReadField = new QueryField(this.clazz, this.getFieldType(this.clazz, token, false), token);
                this.fields.add(lastReadField);
            }
            throw new GraphQLRequestPreparationException("The field <" + this.name + "> has a non finished list of fields (it lacks the finishing '}') while reading <" + this.name + ">");
        }

        void readTokenizerForInputParameters(StringTokenizer st) throws GraphQLRequestPreparationException {
            InputParameterStep step = InputParameterStep.NAME;
            String parameterName = null;
            block17: while (st.hasMoreTokens()) {
                String token;
                switch (token = st.nextToken()) {
                    case "{": {
                        throw new GraphQLRequestPreparationException("Encountered a '{' while reading parameters for the field '" + this.name + "' : if you're using DirectQueries with field's parameter that are Input Types, please consider using Prepared Queries. Otherwise, please correct the query syntax");
                    }
                    case ":": 
                    case " ": {
                        continue block17;
                    }
                    case ",": {
                        if (step == InputParameterStep.NAME) continue block17;
                        throw new GraphQLRequestPreparationException("Misplacer comma for the field '" + this.name + "' is not finished (no closing parenthesis)");
                    }
                    case ")": {
                        if (parameterName == null) {
                            throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + this.name + "' (no parameter has been read)");
                        }
                        if (step != InputParameterStep.NAME) {
                            throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + this.name + "' is not finished (no closing parenthesis)");
                        }
                        return;
                    }
                }
                switch (step) {
                    case NAME: {
                        parameterName = token;
                        step = InputParameterStep.VALUE;
                        break;
                    }
                    case VALUE: {
                        if (token.startsWith("?")) {
                            this.inputParameters.add(new InputParameter(parameterName, token.substring(1), null, false, Builder.this.getCustomScalarGraphQLType(this.owningClazz, this.name, parameterName)));
                        } else if (token.startsWith("&")) {
                            this.inputParameters.add(new InputParameter(parameterName, token.substring(1), null, true, Builder.this.getCustomScalarGraphQLType(this.owningClazz, this.name, parameterName)));
                        } else if (token.startsWith("\"") && token.endsWith("\"")) {
                            String value = token.substring(1, token.length() - 1);
                            this.inputParameters.add(new InputParameter(parameterName, null, value, true, null));
                        } else {
                            if (token.startsWith("\"") || token.endsWith("\"")) {
                                throw new GraphQLRequestPreparationException("Bad parameter value: parameter values should start and finish by \", or not having any \" at the beginning and end.. But it's not the case for the value <" + token + "> of parameter <" + parameterName + ">. Maybe you wanted to add a bind parameter instead (bind parameter must start with a ? or a &");
                            }
                            Object parameterValue = this.getParameterValue(this.owningClazz, this.name, parameterName, token);
                            this.inputParameters.add(new InputParameter(parameterName, null, parameterValue, true, null));
                        }
                        step = InputParameterStep.NAME;
                    }
                }
            }
            throw new GraphQLRequestPreparationException("The list of parameters for the field '" + this.name + "' is not finished (no closing parenthesis)");
        }

        private Object getParameterValue(Class<?> owningClass, String fieldName, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
            Field field;
            Object ret = null;
            try {
                field = owningClass.getDeclaredField(Builder.this.graphqlUtils.getJavaName(fieldName));
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new GraphQLRequestPreparationException("Couldn't parse the value for the parameter '" + parameterName + "' of the field '" + fieldName + "'", e);
            }
            GraphQLInputParameters graphQLInputParameters = field.getDeclaredAnnotation(GraphQLInputParameters.class);
            if (graphQLInputParameters == null) {
                throw new GraphQLRequestPreparationException("[Internal error] The field '" + fieldName + "' is lacking the GraphQLInputParameters annotation");
            }
            String parameterType = null;
            for (int i = 0; i < graphQLInputParameters.names().length; ++i) {
                if (!graphQLInputParameters.names()[i].equals(parameterName)) continue;
                parameterType = graphQLInputParameters.types()[i];
            }
            if (parameterType == null) {
                throw new GraphQLRequestPreparationException("[Internal error] Can't find the type for the parameter '" + parameterName + "' of the field '" + fieldName + "'");
            }
            GraphQLScalarType scalarType = CustomScalarRegistryImpl.customScalarRegistry.getGraphQLScalarType(parameterType);
            if (scalarType != null) {
                ret = scalarType.getCoercing().parseValue((Object)parameterValue);
            } else {
                Class<Comparable<Boolean>> parameterClass;
                String parameterClassname = owningClass.getPackageName() + "." + Builder.this.graphqlUtils.getJavaName(parameterType);
                try {
                    parameterClass = Class.forName(parameterClassname);
                }
                catch (ClassNotFoundException e) {
                    throw new GraphQLRequestPreparationException("Couldn't find the class (" + parameterClassname + ") of the parameter '" + parameterName + "' of the field '" + fieldName + "'", e);
                }
                if (parameterClass.isEnum()) {
                    Method valueOf = Builder.this.graphqlUtils.getMethod("valueOf", parameterClass, String.class);
                    ret = Builder.this.graphqlUtils.invokeMethod(valueOf, null, parameterValue);
                } else if (parameterClass.isAssignableFrom(Boolean.class)) {
                    if (!"true".equals(parameterValue) && !"false".equals(parameterValue)) {
                        throw new GraphQLRequestPreparationException("Only true and false are allowed values for booleans. But the parameter '" + parameterName + "' of the field '" + fieldName + "' has the '" + parameterValue + "'");
                    }
                    ret = "true".equals(parameterValue);
                } else if (parameterClass.isAssignableFrom(Integer.class)) {
                    ret = Integer.parseInt(parameterValue);
                } else if (parameterClass.isAssignableFrom(Float.class)) {
                    ret = Float.valueOf(Float.parseFloat(parameterValue));
                }
            }
            if (ret != null) {
                return ret;
            }
            throw new GraphQLRequestPreparationException("Couldn't parse the value for the parameter '" + parameterName + "' of the field '" + fieldName + "'. The value is '" + parameterValue + "'");
        }

        private Class<?> getFieldType(Class<?> owningClass, String fieldName, boolean returnIdMandatory) throws GraphQLRequestPreparationException {
            if (owningClass.isInterface()) {
                try {
                    Method method = owningClass.getDeclaredMethod("get" + Builder.this.graphqlUtils.getPascalCase(fieldName), new Class[0]);
                    GraphQLNonScalar graphQLNonScalar = method.getAnnotation(GraphQLNonScalar.class);
                    GraphQLScalar graphQLScalar = method.getAnnotation(GraphQLScalar.class);
                    if (graphQLNonScalar != null) {
                        return graphQLNonScalar.javaClass();
                    }
                    if (graphQLScalar != null) {
                        return graphQLScalar.javaClass();
                    }
                    throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the interface '" + owningClass.getName() + "': this method should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
                }
                catch (NoSuchMethodException e) {
                    if (!returnIdMandatory) {
                        return null;
                    }
                    throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
                }
                catch (SecurityException e) {
                    throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
                }
            }
            try {
                Field field = owningClass.getDeclaredField(Builder.this.graphqlUtils.getJavaName(fieldName));
                GraphQLCustomScalar graphQLCustomScalar = field.getAnnotation(GraphQLCustomScalar.class);
                GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
                GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
                if (graphQLCustomScalar != null) {
                    return graphQLCustomScalar.javaClass();
                }
                if (graphQLNonScalar != null) {
                    return graphQLNonScalar.javaClass();
                }
                if (graphQLScalar != null) {
                    return graphQLScalar.javaClass();
                }
                throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "': this field should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
            }
            catch (NoSuchFieldException e) {
                if (!returnIdMandatory) {
                    return null;
                }
                throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
            catch (SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
        }
    }

    private static enum InputParameterStep {
        NAME,
        VALUE;

    }
}

