/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.client.response.Error;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutorImpl
implements QueryExecutor {
    private static Logger logger;
    Client client;
    ObjectMapper objectMapper;
    WebTarget webTarget;

    public QueryExecutorImpl(String graphqlEndpoint) {
        this(graphqlEndpoint, ClientBuilder.newClient(), new ObjectMapper());
    }

    public QueryExecutorImpl(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (graphqlEndpoint.startsWith("http:")) {
            throw new IllegalArgumentException("This GraphQL endpoint is an http one. Please use the relevant Query/Mutation/Subscription constructor (without the SSLContext and HostnameVerifier parameters)");
        }
        this.client = ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(hostnameVerifier).build();
        this.objectMapper = new ObjectMapper();
        this.webTarget = this.client.target(graphqlEndpoint);
    }

    public QueryExecutorImpl(String graphqlEndpoint, Client client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.webTarget = client.target(graphqlEndpoint);
    }

    @Override
    public <T> T execute(ObjectResponse objectResponse, Map<String, Object> parameters, Class<T> valueType) throws GraphQLRequestExecutionException {
        String request = null;
        try {
            request = objectResponse.buildRequest(parameters);
            return this.doJsonRequestExecution(request, valueType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + request + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T execute(String query, Class<T> valueType) throws GraphQLRequestExecutionException {
        try {
            return this.doJsonRequestExecution(query, valueType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException(e.getMessage(), e);
        }
    }

    <T> T doJsonRequestExecution(String jsonRequest, Class<T> valueType) throws IOException, GraphQLRequestExecutionException {
        logger.trace(GRAPHQL_MARKER, "Executing GraphQL request: {}", (Object)jsonRequest);
        Invocation.Builder invocationBuilder = this.webTarget.request(new String[]{"application/json"});
        invocationBuilder.header("Accept", (Object)"application/json");
        JsonResponseWrapper response = (JsonResponseWrapper)invocationBuilder.post(Entity.entity((Object)jsonRequest, (String)"application/json"), JsonResponseWrapper.class);
        if (logger.isTraceEnabled()) {
            logger.trace("Response data: {}", (Object)this.objectMapper.writeValueAsString((Object)response.data));
            logger.trace("Response errors: {}", (Object)this.objectMapper.writeValueAsString(response.errors));
        }
        if (response.errors == null || response.errors.size() == 0) {
            return (T)this.objectMapper.treeToValue((TreeNode)response.data, valueType);
        }
        int nbErrors = 0;
        String agregatedMessage = null;
        for (Error error : response.errors) {
            String msg = error.toString();
            ++nbErrors;
            logger.error(GRAPHQL_MARKER, msg);
            if (agregatedMessage == null) {
                agregatedMessage = msg;
                continue;
            }
            agregatedMessage = agregatedMessage + ", ";
            agregatedMessage = agregatedMessage + msg;
        }
        if (nbErrors == 0) {
            throw new GraphQLRequestExecutionException("An unknown error occured");
        }
        throw new GraphQLRequestExecutionException(nbErrors + " errors occured: " + agregatedMessage);
    }

    static {
        GRAPHQL_QUERY_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_MUTATION_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_SUBSCRIPTION_MARKER.add(GRAPHQL_MARKER);
        logger = LoggerFactory.getLogger(QueryExecutorImpl.class);
    }
}

