/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.SubscriptionConnectionListener;
import graphql.servlet.internal.ApolloSubscriptionProtocolFactory;
import graphql.servlet.internal.FallbackSubscriptionProtocolFactory;
import graphql.servlet.internal.SubscriptionHandlerInput;
import graphql.servlet.internal.SubscriptionProtocolFactory;
import graphql.servlet.internal.SubscriptionProtocolHandler;
import graphql.servlet.internal.WsSessionSubscriptions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLWebsocketServlet
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(GraphQLWebsocketServlet.class);
    private static final String HANDSHAKE_REQUEST_KEY = HandshakeRequest.class.getName();
    private static final String PROTOCOL_HANDLER_REQUEST_KEY = SubscriptionProtocolHandler.class.getName();
    private static final CloseReason ERROR_CLOSE_REASON = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Internal Server Error");
    private static final CloseReason SHUTDOWN_CLOSE_REASON = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Server Shut Down");
    private final List<SubscriptionProtocolFactory> subscriptionProtocolFactories;
    private final SubscriptionProtocolFactory fallbackSubscriptionProtocolFactory;
    private final List<String> allSubscriptionProtocols;
    private final Map<Session, WsSessionSubscriptions> sessionSubscriptionCache = new HashMap<Session, WsSessionSubscriptions>();
    private final SubscriptionHandlerInput subscriptionHandlerInput;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private final Object cacheLock = new Object();

    public GraphQLWebsocketServlet(GraphQLQueryInvoker queryInvoker, GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper) {
        this(queryInvoker, invocationInputFactory, graphQLObjectMapper, null);
    }

    public GraphQLWebsocketServlet(GraphQLQueryInvoker queryInvoker, GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper, SubscriptionConnectionListener subscriptionConnectionListener) {
        this.subscriptionHandlerInput = new SubscriptionHandlerInput(invocationInputFactory, queryInvoker, graphQLObjectMapper, subscriptionConnectionListener);
        this.subscriptionProtocolFactories = Collections.singletonList(new ApolloSubscriptionProtocolFactory(this.subscriptionHandlerInput));
        this.fallbackSubscriptionProtocolFactory = new FallbackSubscriptionProtocolFactory(this.subscriptionHandlerInput);
        this.allSubscriptionProtocols = Stream.concat(this.subscriptionProtocolFactories.stream(), Stream.of(this.fallbackSubscriptionProtocolFactory)).map(SubscriptionProtocolFactory::getProtocol).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(final Session session, EndpointConfig endpointConfig) {
        final WsSessionSubscriptions subscriptions = new WsSessionSubscriptions();
        final HandshakeRequest request = (HandshakeRequest)session.getUserProperties().get(HANDSHAKE_REQUEST_KEY);
        final SubscriptionProtocolHandler subscriptionProtocolHandler = (SubscriptionProtocolHandler)session.getUserProperties().get(PROTOCOL_HANDLER_REQUEST_KEY);
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.isShuttingDown.get()) {
                throw new IllegalStateException("Server is shutting down!");
            }
            this.sessionSubscriptionCache.put(session, subscriptions);
        }
        log.debug("Session opened: {}, {}", (Object)session.getId(), (Object)endpointConfig);
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String text) {
                try {
                    subscriptionProtocolHandler.onMessage(request, session, subscriptions, text);
                }
                catch (Throwable t) {
                    log.error("Error executing websocket query for session: {}", (Object)session.getId(), (Object)t);
                    GraphQLWebsocketServlet.this.closeUnexpectedly(session, t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        WsSessionSubscriptions subscriptions;
        log.debug("Session closed: {}, {}", (Object)session.getId(), (Object)closeReason);
        Object object = this.cacheLock;
        synchronized (object) {
            subscriptions = this.sessionSubscriptionCache.remove(session);
        }
        if (subscriptions != null) {
            subscriptions.close();
        }
    }

    public void onError(Session session, Throwable thr) {
        log.error("Error in websocket session: {}", (Object)session.getId(), (Object)thr);
        this.closeUnexpectedly(session, thr);
    }

    private void closeUnexpectedly(Session session, Throwable t) {
        try {
            session.close(ERROR_CLOSE_REASON);
        }
        catch (IOException e) {
            log.error("Error closing websocket session for session: {}", (Object)session.getId(), (Object)t);
        }
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        sec.getUserProperties().put(HANDSHAKE_REQUEST_KEY, request);
        List<String> protocol = (List<String>)request.getHeaders().get("Sec-WebSocket-Protocol");
        if (protocol == null) {
            protocol = Collections.emptyList();
        }
        SubscriptionProtocolFactory subscriptionProtocolFactory = this.getSubscriptionProtocolFactory(protocol);
        sec.getUserProperties().put(PROTOCOL_HANDLER_REQUEST_KEY, subscriptionProtocolFactory.createHandler());
        if (request.getHeaders().get("Sec-WebSocket-Accept") != null) {
            response.getHeaders().put("Sec-WebSocket-Accept", this.allSubscriptionProtocols);
        }
        if (!protocol.isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Protocol", Collections.singletonList(subscriptionProtocolFactory.getProtocol()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginShutDown() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.isShuttingDown.set(true);
            HashMap<Session, WsSessionSubscriptions> copy = new HashMap<Session, WsSessionSubscriptions>(this.sessionSubscriptionCache);
            copy.forEach((session, wsSessionSubscriptions) -> {
                wsSessionSubscriptions.close();
                try {
                    session.close(SHUTDOWN_CLOSE_REASON);
                }
                catch (IOException e) {
                    log.error("Error closing websocket session!", (Throwable)e);
                }
            });
            copy.clear();
            if (!this.sessionSubscriptionCache.isEmpty()) {
                log.error("GraphQLWebsocketServlet did not shut down cleanly!");
                this.sessionSubscriptionCache.clear();
            }
        }
        this.isShutDown.set(true);
    }

    public boolean isShutDown() {
        return this.isShutDown.get();
    }

    private SubscriptionProtocolFactory getSubscriptionProtocolFactory(List<String> accept) {
        for (String protocol : accept) {
            for (SubscriptionProtocolFactory subscriptionProtocolFactory : this.subscriptionProtocolFactories) {
                if (!subscriptionProtocolFactory.getProtocol().equals(protocol)) continue;
                return subscriptionProtocolFactory;
            }
        }
        return this.fallbackSubscriptionProtocolFactory;
    }
}

