/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GraphQLConfiguration {
    private GraphQLInvocationInputFactory invocationInputFactory;
    private GraphQLQueryInvoker queryInvoker = GraphQLQueryInvoker.newBuilder().build();
    private GraphQLObjectMapper objectMapper = GraphQLObjectMapper.newBuilder().build();
    private List<GraphQLServletListener> listeners;
    private boolean asyncServletModeEnabled;

    public static Builder with(GraphQLSchema schema) {
        return GraphQLConfiguration.with(new DefaultGraphQLSchemaProvider(schema));
    }

    public static Builder with(GraphQLSchemaProvider schemaProvider) {
        return new Builder(GraphQLInvocationInputFactory.newBuilder(schemaProvider));
    }

    static Builder with(GraphQLInvocationInputFactory invocationInputFactory) {
        return new Builder(invocationInputFactory);
    }

    private GraphQLConfiguration(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper objectMapper, List<GraphQLServletListener> listeners, boolean asyncServletModeEnabled) {
        this.invocationInputFactory = invocationInputFactory;
        this.queryInvoker = queryInvoker;
        this.objectMapper = objectMapper;
        this.listeners = listeners;
        this.asyncServletModeEnabled = asyncServletModeEnabled;
    }

    public GraphQLInvocationInputFactory getInvocationInputFactory() {
        return this.invocationInputFactory;
    }

    public GraphQLQueryInvoker getQueryInvoker() {
        return this.queryInvoker;
    }

    public GraphQLObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public List<GraphQLServletListener> getListeners() {
        return new ArrayList<GraphQLServletListener>(this.listeners);
    }

    public boolean isAsyncServletModeEnabled() {
        return this.asyncServletModeEnabled;
    }

    public void add(GraphQLServletListener listener) {
        this.listeners.add(listener);
    }

    public boolean remove(GraphQLServletListener listener) {
        return this.listeners.remove(listener);
    }

    public static class Builder {
        private GraphQLInvocationInputFactory.Builder invocationInputFactoryBuilder;
        private GraphQLInvocationInputFactory invocationInputFactory;
        private GraphQLQueryInvoker queryInvoker = GraphQLQueryInvoker.newBuilder().build();
        private GraphQLObjectMapper objectMapper = GraphQLObjectMapper.newBuilder().build();
        private List<GraphQLServletListener> listeners = new ArrayList<GraphQLServletListener>();
        private boolean asyncServletModeEnabled = false;

        private Builder(GraphQLInvocationInputFactory.Builder invocationInputFactoryBuilder) {
            this.invocationInputFactoryBuilder = invocationInputFactoryBuilder;
        }

        private Builder(GraphQLInvocationInputFactory invocationInputFactory) {
            this.invocationInputFactory = invocationInputFactory;
        }

        public Builder with(GraphQLQueryInvoker queryInvoker) {
            this.queryInvoker = queryInvoker;
            return this;
        }

        public Builder with(GraphQLObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder with(List<GraphQLServletListener> listeners) {
            this.listeners = Objects.requireNonNull(listeners, "listeners must not be null");
            return this;
        }

        public Builder with(boolean asyncServletModeEnabled) {
            this.asyncServletModeEnabled = asyncServletModeEnabled;
            return this;
        }

        public Builder with(GraphQLContextBuilder contextBuilder) {
            this.invocationInputFactoryBuilder.withGraphQLContextBuilder(contextBuilder);
            return this;
        }

        public Builder with(GraphQLRootObjectBuilder rootObjectBuilder) {
            this.invocationInputFactoryBuilder.withGraphQLRootObjectBuilder(rootObjectBuilder);
            return this;
        }

        public GraphQLConfiguration build() {
            return new GraphQLConfiguration(this.invocationInputFactory != null ? this.invocationInputFactory : this.invocationInputFactoryBuilder.build(), this.queryInvoker, this.objectMapper, this.listeners, this.asyncServletModeEnabled);
        }
    }
}

