/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.DecoratedExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.HttpRequestHandler;
import graphql.kickstart.servlet.HttpRequestHandlerImpl;
import graphql.kickstart.servlet.core.GraphQLMBean;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import graphql.schema.GraphQLFieldDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLHttpServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphQLHttpServlet.class);
    @Deprecated
    private final List<GraphQLServletListener> listeners;
    private GraphQLConfiguration configuration;
    private HttpRequestHandler requestHandler;

    public AbstractGraphQLHttpServlet() {
        this(null);
    }

    public AbstractGraphQLHttpServlet(List<GraphQLServletListener> listeners) {
        this.listeners = listeners != null ? new ArrayList<GraphQLServletListener>(listeners) : new ArrayList();
    }

    @Deprecated
    protected abstract GraphQLQueryInvoker getQueryInvoker();

    @Deprecated
    protected abstract GraphQLInvocationInputFactory getInvocationInputFactory();

    @Deprecated
    protected abstract GraphQLObjectMapper getGraphQLObjectMapper();

    @Deprecated
    protected abstract boolean isAsyncServletMode();

    protected GraphQLConfiguration getConfiguration() {
        return GraphQLConfiguration.with(this.getInvocationInputFactory()).with(this.getQueryInvoker()).with(this.getGraphQLObjectMapper()).with(this.isAsyncServletMode()).with(this.listeners).build();
    }

    public void init() {
        if (this.configuration == null) {
            this.configuration = this.getConfiguration();
            this.requestHandler = new HttpRequestHandlerImpl(this.configuration);
        }
    }

    public void addListener(GraphQLServletListener servletListener) {
        if (this.configuration != null) {
            this.configuration.add(servletListener);
        } else {
            this.listeners.add(servletListener);
        }
    }

    public void removeListener(GraphQLServletListener servletListener) {
        if (this.configuration != null) {
            this.configuration.remove(servletListener);
        } else {
            this.listeners.remove(servletListener);
        }
    }

    @Override
    public String[] getQueries() {
        return (String[])this.configuration.getInvocationInputFactory().getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.configuration.getInvocationInputFactory().getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            GraphQLRequest graphQLRequest = GraphQLRequest.createQueryOnlyRequest((String)query);
            GraphQLSingleInvocationInput invocationInput = this.configuration.getInvocationInputFactory().create(graphQLRequest);
            DecoratedExecutionResult result = this.configuration.getGraphQLInvoker().query((GraphQLInvocationInput)invocationInput).getResult();
            return this.configuration.getObjectMapper().serializeResultAsJson((ExecutionResult)result);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void doRequestAsync(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler) {
        if (this.configuration.isAsyncServletModeEnabled()) {
            AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
            asyncContext.setTimeout(this.configuration.getAsyncTimeout());
            HttpServletRequest asyncRequest = (HttpServletRequest)asyncContext.getRequest();
            HttpServletResponse asyncResponse = (HttpServletResponse)asyncContext.getResponse();
            this.configuration.getAsyncExecutor().execute(() -> this.doRequest(asyncRequest, asyncResponse, handler, asyncContext));
        } else {
            this.doRequest(request, response, handler, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler, AsyncContext asyncContext) {
        List<GraphQLServletListener.RequestCallback> requestCallbacks = this.runListeners(l -> l.onRequest(request, response));
        try {
            handler.handle(request, response);
            this.runCallbacks(requestCallbacks, c -> c.onSuccess(request, response));
        }
        catch (Throwable t) {
            log.error("Error executing GraphQL request!", t);
            this.runCallbacks(requestCallbacks, c -> c.onError(request, response, t));
        }
        finally {
            this.runCallbacks(requestCallbacks, c -> c.onFinally(request, response));
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.init();
        this.doRequestAsync(req, resp, this.requestHandler);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.init();
        this.doRequestAsync(req, resp, this.requestHandler);
    }

    private <R> List<R> runListeners(Function<? super GraphQLServletListener, R> action) {
        return this.configuration.getListeners().stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Throwable t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> void runCallbacks(List<T> callbacks, Consumer<T> action) {
        callbacks.forEach(callback -> {
            try {
                action.accept(callback);
            }
            catch (Throwable t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }
}

