/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.DirectiveTest;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lgraphql/kickstart/tools/DirectiveTest;", "", "()V", "should apply correctly the @uppercase directive", "", "should compile schema with directive that has enum parameter", "AllowedDirective", "AllowedState", "Book", "QueryResolver", "UppercaseDirective", "UsersQueryResolver", "graphql-java-tools"})
public final class DirectiveTest {
    @Test
    public final void should apply correctly the @uppercase directive() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase on FIELD_DEFINITION\n                \n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String @uppercase\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new UsersQueryResolver()}).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                users {\n                    edges {\n                        node {\n                            id\n                            name\n                        }\n                    }\n                }\n            }\n            ");
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"users", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LUKE")}))))))));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    @Ignore(value="Ignore until enums work in directives")
    public final void should compile schema with directive that has enum parameter() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @allowed(state: [AllowedState!]) on FIELD_DEFINITION\n                \n                enum AllowedState {\n                    ALLOWED\n                    DISALLOWED\n                }\n                \n                type Book {\n                    id: Int!\n                    name: String! @allowed(state: [ALLOWED])\n                }\n                \n                type Query {\n                    books: [Book!]\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()}).directive("allowed", (SchemaDirectiveWiring)new AllowedDirective()).build().makeExecutableSchema();
        GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "books", "", "Lgraphql/kickstart/tools/DirectiveTest$Book;", "graphql-java-tools"})
    private static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<Book> books() {
            return CollectionsKt.listOf((Object)new Book(42L, "Test Book"));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$Book;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class Book {
        private final long id;
        @NotNull
        private final String name;

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public Book(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Book copy(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Book(id, name);
        }

        public static /* synthetic */ Book copy$default(Book book, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = book.id;
            }
            if ((n & 2) != 0) {
                string = book.name;
            }
            return book.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "Book(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            long l = this.id;
            String string = this.name;
            return (int)(l ^ l >>> 32) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Book)) break block3;
                    Book book = (Book)object;
                    if (this.id != book.id || !Intrinsics.areEqual((Object)this.name, (Object)book.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$AllowedState;", "", "(Ljava/lang/String;I)V", "ALLOWED", "DISALLOWED", "graphql-java-tools"})
    private static final class AllowedState
    extends Enum<AllowedState> {
        public static final /* enum */ AllowedState ALLOWED;
        public static final /* enum */ AllowedState DISALLOWED;
        private static final /* synthetic */ AllowedState[] $VALUES;

        static {
            AllowedState[] allowedStateArray = new AllowedState[2];
            AllowedState[] allowedStateArray2 = allowedStateArray;
            allowedStateArray[0] = ALLOWED = new AllowedState();
            allowedStateArray[1] = DISALLOWED = new AllowedState();
            $VALUES = allowedStateArray;
        }

        public static AllowedState[] values() {
            return (AllowedState[])$VALUES.clone();
        }

        public static AllowedState valueOf(String string) {
            return Enum.valueOf(AllowedState.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$AllowedDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "graphql-java-tools"})
    private static final class AllowedDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            GraphQLFieldDefinition field;
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLFieldDefinition graphQLFieldDefinition = field = (GraphQLFieldDefinition)environment.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"field");
            return graphQLFieldDefinition;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UppercaseDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "graphql-java-tools"})
    private static final class UppercaseDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
            GraphQLFieldsContainer parentType = environment.getFieldsContainer();
            DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
            DataFetcher wrappedDataFetcher2 = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (BiFunction)onField.wrappedDataFetcher.1.INSTANCE);
            environment.getCodeRegistry().dataFetcher(parentType, field, wrappedDataFetcher2);
            GraphQLFieldDefinition graphQLFieldDefinition = field;
            Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"field");
            return graphQLFieldDefinition;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "users", "Lgraphql/relay/Connection;", "Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver$User;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "User", "graphql-java-tools"})
    private static final class UsersQueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> users(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new User(1L, "Luke"))).get(env);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"SimpleListConnection(lis\u2026er(1L, \"Luke\"))).get(env)");
            return connection;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver$User;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
        private static final class User {
            private final long id;
            @NotNull
            private final String name;

            public final long getId() {
                return this.id;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public User(long id, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.id = id;
                this.name = name;
            }

            public final long component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.name;
            }

            @NotNull
            public final User copy(long id, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new User(id, name);
            }

            public static /* synthetic */ User copy$default(User user, long l, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    l = user.id;
                }
                if ((n & 2) != 0) {
                    string = user.name;
                }
                return user.copy(l, string);
            }

            @NotNull
            public String toString() {
                return "User(id=" + this.id + ", name=" + this.name + ")";
            }

            public int hashCode() {
                long l = this.id;
                String string = this.name;
                return (int)(l ^ l >>> 32) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof User)) break block3;
                        User user = (User)object;
                        if (this.id != user.id || !Intrinsics.areEqual((Object)this.name, (Object)user.name)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

