/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.kickstart.tools.GraphQLMutationResolver;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaClassScannerError;
import graphql.kickstart.tools.SchemaError;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.SchemaParserTest;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.aop.framework.ProxyFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001e\u0018\u00002\u00020\u0001:\n\u001c\u001d\u001e\u001f !\"#$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\b\u0010\u0011\u001a\u00020\bH\u0007J\b\u0010\u0012\u001a\u00020\bH\u0007J\b\u0010\u0013\u001a\u00020\bH\u0007J\b\u0010\u0014\u001a\u00020\bH\u0007J\b\u0010\u0015\u001a\u00020\bH\u0007J\b\u0010\u0016\u001a\u00020\bH\u0007J\b\u0010\u0017\u001a\u00020\bH\u0007J\b\u0010\u0018\u001a\u00020\bH\u0007J\b\u0010\u0019\u001a\u00020\bH\u0007J\b\u0010\u001a\u001a\u00020\bH\u0007J\b\u0010\u001b\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest;", "", "()V", "builder", "Lgraphql/kickstart/tools/SchemaParserBuilder;", "expectedEx", "Lorg/junit/rules/ExpectedException;", "NonNull and nullable input arguments should resolve to GraphQLInputObjectType", "", "allow circular relations in input objects", "builder doesn't throw FileNotFound exception when file is present", "builder throws FileNotFound exception when file is missing", "interface implementing an interface should have non-empty interface list", "parser handles enums with overridden toString method", "parser handles spring AOP proxied resolvers by default", "parser should allow setting custom generic wrappers", "parser should allow turning off default generic wrappers", "parser should include source location for field definition", "parser should include source location for field definition when loaded from single classpath file", "parser should parse correctly when Query resolver is given", "parser should parse correctly when multiple query resolvers are given", "parser should parse correctly when multiple resolvers for the same data type are given", "parser should throw descriptive exception when object is used as input type incorrectly", "parser throws ResolverError when Query resolver is given without correct method", "parser throws SchemaError when Query resolver is missing", "setup", "support enum types if only used as input type", "support enum types if only used in input Map", "AnotherObj", "CustomEnum", "CustomGenericWrapper", "EnumType", "Filter", "MultiLevelInterfaceResolver", "Obj", "ProxiedResolver", "QueryWithIdResolver", "RootObj", "graphql-java-tools"})
public final class SchemaParserTest {
    private SchemaParserBuilder builder;
    @Rule
    @JvmField
    @NotNull
    public ExpectedException expectedEx;

    @Before
    public final void setup() {
        this.builder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ");
    }

    @Test(expected=FileNotFoundException.class)
    public final void builder throws FileNotFound exception when file is missing() {
        SchemaParserBuilder schemaParserBuilder = this.builder;
        if (schemaParserBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        }
        schemaParserBuilder.file("/404").build();
    }

    @Test
    public final void builder doesn't throw FileNotFound exception when file is present() {
        SchemaParser.Companion.newParser().file("Test.graphqls").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String getId() {
                return "1";
            }
        }}).build();
    }

    @Test(expected=SchemaClassScannerError.class)
    public final void parser throws SchemaError when Query resolver is missing() {
        SchemaParserBuilder schemaParserBuilder = this.builder;
        if (schemaParserBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        }
        schemaParserBuilder.build().makeExecutableSchema();
    }

    @Test(expected=FieldResolverError.class)
    public final void parser throws ResolverError when Query resolver is given without correct method() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}}).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when Query resolver is given() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final int get(int i) {
                return i;
            }
        }}).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when multiple query resolvers are given() {
        SchemaParser.Companion.newParser().schemaString("\n                type Obj {\n                    name: String\n                }\n    \n                type AnotherObj {\n                    key: String\n                }\n    \n                type Query {\n                    obj: Obj\n                    anotherObj: AnotherObj\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final Obj getObj() {
                return new Obj();
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final AnotherObj getAnotherObj() {
                return new AnotherObj();
            }
        }}).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when multiple resolvers for the same data type are given() {
        SchemaParser.Companion.newParser().schemaString("\n                type RootObj {\n                    obj: Obj\n                    anotherObj: AnotherObj\n                }\n                \n                type Obj {\n                    name: String\n                }\n                \n                type AnotherObj {\n                    key: String\n                }\n                \n                type Query {\n                    rootObj: RootObj\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final RootObj getRootObj() {
                return new RootObj();
            }
        }, (GraphQLResolver)new GraphQLResolver<RootObj>(){

            @NotNull
            public final Obj getObj(@NotNull RootObj rootObj) {
                Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
                return new Obj();
            }
        }, (GraphQLResolver)new GraphQLResolver<RootObj>(){

            @NotNull
            public final AnotherObj getAnotherObj(@NotNull RootObj rootObj) {
                Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
                return new AnotherObj();
            }
        }}).build().makeExecutableSchema();
    }

    @Test
    public final void parser should allow setting custom generic wrappers() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    one: Object!\n                    two: Object!\n                }\n                \n                type Object {\n                    name: String!\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final CustomGenericWrapper<Integer, Obj> one() {
                return null;
            }

            @Nullable
            public final Obj two() {
                return null;
            }
        }}).options(SchemaParserOptions.Companion.newOptions().genericWrappers(new SchemaParserOptions.GenericWrapper[]{new SchemaParserOptions.GenericWrapper(Reflection.getOrCreateKotlinClass(CustomGenericWrapper.class), 1)}).build()).build().makeExecutableSchema();
    }

    @Test(expected=SchemaClassScannerError.class)
    public final void parser should allow turning off default generic wrappers() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    one: Object!\n                    two: Object!\n                }\n                \n                type Object {\n                    toString: String!\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final Future<Obj> one() {
                return null;
            }

            @Nullable
            public final Obj two() {
                return null;
            }
        }}).options(SchemaParserOptions.Companion.newOptions().useDefaultGenericWrappers(false).build()).build().makeExecutableSchema();
    }

    @Test
    public final void parser should throw descriptive exception when object is used as input type incorrectly() {
        this.expectedEx.expect(SchemaError.class);
        this.expectedEx.expectMessage("Was a type only permitted for object types incorrectly used as an input type, or vice-versa");
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    name(filter: Filter): [String]\n                }\n                \n                type Filter {\n                    filter: String\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final List<String> name(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return null;
            }
        }}).build().makeExecutableSchema();
        throw (Throwable)((Object)new AssertionError((Object)"should not be called"));
    }

    @Test
    public final void parser handles spring AOP proxied resolvers by default() {
        Object object = new ProxyFactory((Object)new ProxiedResolver()).getProxy();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.kickstart.tools.GraphQLQueryResolver");
        }
        GraphQLQueryResolver resolver2 = (GraphQLQueryResolver)object;
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    test: [String]\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)resolver2}).build();
    }

    @Test
    public final void parser handles enums with overridden toString method() {
        SchemaParser.Companion.newParser().schemaString("\n                enum CustomEnum {\n                    FOO\n                }\n                \n                type Query {\n                    customEnum: CustomEnum\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final CustomEnum customEnum() {
                return null;
            }
        }}).build().makeExecutableSchema();
    }

    @Test
    public final void parser should include source location for field definition() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("type Query {\n    id: ID!\n}").resolvers(new GraphQLResolver[]{(GraphQLResolver)new QueryWithIdResolver()}).build().makeExecutableSchema();
        GraphQLFieldDefinition graphQLFieldDefinition = schema2.getObjectType("Query").getFieldDefinition("id");
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"schema.getObjectType(\"Qu\u2026.getFieldDefinition(\"id\")");
        FieldDefinition fieldDefinition = graphQLFieldDefinition.getDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)fieldDefinition, (String)"schema.getObjectType(\"Qu\u2026)\n            .definition");
        SourceLocation sourceLocation = fieldDefinition.getSourceLocation();
        TestUtilsKt.assertNotNull(sourceLocation);
        SourceLocation sourceLocation2 = sourceLocation;
        Intrinsics.checkNotNullExpressionValue((Object)sourceLocation2, (String)"sourceLocation");
        TestUtilsKt.assertEquals(sourceLocation2.getLine(), 2);
        TestUtilsKt.assertEquals(sourceLocation.getColumn(), 5);
        TestUtilsKt.assertNull(sourceLocation.getSourceName());
    }

    @Test
    public final void parser should include source location for field definition when loaded from single classpath file() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("Test.graphqls").resolvers(new GraphQLResolver[]{(GraphQLResolver)new QueryWithIdResolver()}).build().makeExecutableSchema();
        GraphQLFieldDefinition graphQLFieldDefinition = schema2.getObjectType("Query").getFieldDefinition("id");
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"schema.getObjectType(\"Qu\u2026.getFieldDefinition(\"id\")");
        FieldDefinition fieldDefinition = graphQLFieldDefinition.getDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)fieldDefinition, (String)"schema.getObjectType(\"Qu\u2026)\n            .definition");
        SourceLocation sourceLocation = fieldDefinition.getSourceLocation();
        TestUtilsKt.assertNotNull(sourceLocation);
        SourceLocation sourceLocation2 = sourceLocation;
        Intrinsics.checkNotNullExpressionValue((Object)sourceLocation2, (String)"sourceLocation");
        TestUtilsKt.assertEquals(sourceLocation2.getLine(), 2);
        TestUtilsKt.assertEquals(sourceLocation.getColumn(), 3);
        TestUtilsKt.assertEquals(sourceLocation.getSourceName(), "Test.graphqls");
    }

    @Test
    public final void support enum types if only used as input type() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query { test: Boolean }\n                        \n                type Mutation {\n                    save(input: SaveInput!): Boolean\n                }\n                \n                input SaveInput {\n                    type: EnumType!\n                }\n                \n                enum EnumType {\n                    TEST\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean save(@NotNull support enum types if only used as input type.SaveInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return false;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }}).dictionary(Reflection.getOrCreateKotlinClass(EnumType.class)).build().makeExecutableSchema();
    }

    @Test
    public final void support enum types if only used in input Map() {
        SchemaParser.Companion.newParser().schemaString("\n                type Query { test: Boolean }\n                        \n                type Mutation {\n                    save(input: SaveInput!): Boolean\n                }\n                \n                input SaveInput {\n                    age: Int\n                    type: EnumType!\n                }\n                \n                enum EnumType {\n                    TEST\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean save(@NotNull Map<?, ?> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                return false;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }}).dictionary(Reflection.getOrCreateKotlinClass(EnumType.class)).build().makeExecutableSchema();
    }

    @Test
    public final void allow circular relations in input objects() {
        SchemaParser.Companion.newParser().schemaString("\n                input A {\n                    id: ID!\n                    b: B\n                }\n                input B {\n                    id: ID!\n                    a: A\n                }\n                input C {\n                    id: ID!\n                    c: C\n                }\n                type Query { test: Boolean }\n                type Mutation {\n                    test(input: A!): Boolean\n                    testC(input: C!): Boolean\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean test(@NotNull allow circular relations in input objects.A a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                return true;
            }

            public final boolean testC(@NotNull allow circular relations in input objects.C c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                return true;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }}).build().makeExecutableSchema();
    }

    @Test
    public final void interface implementing an interface should have non-empty interface list() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                interface Trait {\n                    id: ID!\n                }\n                interface MammalTrait implements Trait {\n                    id: ID!\n                }\n                type PoodleTrait implements Trait & MammalTrait {\n                    id: ID!\n                }\n\n                interface Animal {\n                    id: ID!\n                    traits: [Trait]\n                }\n                interface Dog implements Animal {\n                    id: ID!\n                    traits: [MammalTrait]\n                }\n                type Poodle implements Animal & Dog {\n                    id: ID!\n                    traits: [PoodleTrait]\n                }\n\n                type Query { test: [Poodle] }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new MultiLevelInterfaceResolver()}).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("Trait");
        if (graphQLType == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        }
        GraphQLInterfaceType traitInterface = (GraphQLInterfaceType)graphQLType;
        GraphQLType graphQLType2 = schema2.getType("Animal");
        if (graphQLType2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        }
        GraphQLInterfaceType animalInterface = (GraphQLInterfaceType)graphQLType2;
        GraphQLType graphQLType3 = schema2.getType("MammalTrait");
        if (graphQLType3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        }
        GraphQLInterfaceType mammalTraitInterface = (GraphQLInterfaceType)graphQLType3;
        GraphQLType graphQLType4 = schema2.getType("Dog");
        if (graphQLType4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        }
        GraphQLInterfaceType dogInterface = (GraphQLInterfaceType)graphQLType4;
        GraphQLType graphQLType5 = schema2.getType("Poodle");
        if (graphQLType5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        }
        GraphQLObjectType poodleObject = (GraphQLObjectType)graphQLType5;
        GraphQLType graphQLType6 = schema2.getType("PoodleTrait");
        if (graphQLType6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        }
        GraphQLObjectType poodleTraitObject = (GraphQLObjectType)graphQLType6;
        boolean bl = poodleObject.getInterfaces().containsAll(CollectionsKt.listOf((Object[])new GraphQLInterfaceType[]{dogInterface, animalInterface}));
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = poodleTraitObject.getInterfaces().containsAll(CollectionsKt.listOf((Object[])new GraphQLInterfaceType[]{mammalTraitInterface, traitInterface}));
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = dogInterface.getInterfaces().contains(animalInterface);
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = mammalTraitInterface.getInterfaces().contains(traitInterface);
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        InterfaceTypeDefinition interfaceTypeDefinition = traitInterface.getDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)interfaceTypeDefinition, (String)"traitInterface.definition");
        bl = interfaceTypeDefinition.getImplements().isEmpty();
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl8 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        InterfaceTypeDefinition interfaceTypeDefinition2 = animalInterface.getDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)interfaceTypeDefinition2, (String)"animalInterface.definition");
        bl = interfaceTypeDefinition2.getImplements().isEmpty();
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl9 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Test
    public final void NonNull and nullable input arguments should resolve to GraphQLInputObjectType() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testNonNullable(filter: Filter!): Boolean\n                    testNullable(filter: Filter): Boolean\n                }\n        \n                input Filter {\n                    filter: String\n                }\n                ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean testNonNullable(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return false;
            }

            public final boolean testNullable(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return false;
            }
        }}).directiveWiring(new SchemaDirectiveWiring(){

            @NotNull
            public GraphQLArgument onArgument(@NotNull SchemaDirectiveWiringEnvironment<GraphQLArgument> environment) {
                Intrinsics.checkNotNullParameter(environment, (String)"environment");
                GraphQLDirectiveContainer graphQLDirectiveContainer = environment.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)graphQLDirectiveContainer, (String)"environment.element");
                GraphQLInputType graphQLInputType = ((GraphQLArgument)graphQLDirectiveContainer).getType();
                if (graphQLInputType instanceof GraphQLNonNull) {
                    GraphQLDirectiveContainer graphQLDirectiveContainer2 = environment.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)graphQLDirectiveContainer2, (String)"environment.element");
                    GraphQLInputType graphQLInputType2 = ((GraphQLArgument)graphQLDirectiveContainer2).getType();
                    if (graphQLInputType2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLNonNull");
                    }
                    boolean bl = ((GraphQLNonNull)graphQLInputType2).getWrappedType() instanceof GraphQLInputObjectType;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                }
                GraphQLDirectiveContainer graphQLDirectiveContainer3 = environment.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)graphQLDirectiveContainer3, (String)"environment.element");
                return (GraphQLArgument)graphQLDirectiveContainer3;
            }
        }).build().makeExecutableSchema();
        GraphQLFieldDefinition graphQLFieldDefinition = schema2.getObjectType("Query").getFieldDefinition("testNonNullable");
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"schema.getObjectType(\"Qu\u2026nition(\"testNonNullable\")");
        List list = graphQLFieldDefinition.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schema.getObjectType(\"Qu\u2026\")\n            .arguments");
        GraphQLArgument testNonNullableArgument = (GraphQLArgument)CollectionsKt.first((List)list);
        GraphQLFieldDefinition graphQLFieldDefinition2 = schema2.getObjectType("Query").getFieldDefinition("testNullable");
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition2, (String)"schema.getObjectType(\"Qu\u2026efinition(\"testNullable\")");
        List list2 = graphQLFieldDefinition2.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"schema.getObjectType(\"Qu\u2026\")\n            .arguments");
        GraphQLArgument testNullableArgument = (GraphQLArgument)CollectionsKt.first((List)list2);
        GraphQLArgument graphQLArgument = testNonNullableArgument;
        Intrinsics.checkNotNullExpressionValue((Object)graphQLArgument, (String)"testNonNullableArgument");
        boolean bl = graphQLArgument.getType() instanceof GraphQLNonNull;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        GraphQLInputType graphQLInputType = testNonNullableArgument.getType();
        if (graphQLInputType == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLNonNull");
        }
        bl = ((GraphQLNonNull)graphQLInputType).getWrappedType() instanceof GraphQLInputObjectType;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        GraphQLArgument graphQLArgument2 = testNullableArgument;
        Intrinsics.checkNotNullExpressionValue((Object)graphQLArgument2, (String)"testNullableArgument");
        bl = graphQLArgument2.getType() instanceof GraphQLInputObjectType;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public SchemaParserTest() {
        ExpectedException expectedException = ExpectedException.none();
        Intrinsics.checkNotNullExpressionValue((Object)expectedException, (String)"ExpectedException.none()");
        this.expectedEx = expectedException;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\f"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "test", "", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Poodle;", "Animal", "Dog", "MammalTrait", "Poodle", "PoodleTrait", "Trait", "graphql-java-tools"})
    public static final class MultiLevelInterfaceResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<Poodle> test() {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface Trait {
            @NotNull
            public String getId();

            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface MammalTrait
        extends Trait {
            @Override
            @NotNull
            public String getId();

            @Override
            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$PoodleTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface PoodleTrait
        extends MammalTrait {
            @Override
            @NotNull
            public String getId();

            @Override
            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Animal;", "T", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "traits", "", "getTraits", "()Ljava/util/List;", "setTraits", "(Ljava/util/List;)V", "graphql-java-tools"})
        public static abstract class Animal<T extends Trait> {
            @Nullable
            private String id;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }

            @NotNull
            public abstract List<T> getTraits();

            public abstract void setTraits(@NotNull List<? extends T> var1);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004R\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Dog;", "T", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Animal;", "()V", "traits", "", "getTraits", "()Ljava/util/List;", "setTraits", "(Ljava/util/List;)V", "graphql-java-tools"})
        public static abstract class Dog<T extends MammalTrait>
        extends Animal<T> {
            @Override
            @NotNull
            public abstract List<T> getTraits();

            @Override
            public abstract void setTraits(@NotNull List<? extends T> var1);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Poodle;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Dog;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$PoodleTrait;", "traits", "", "(Ljava/util/List;)V", "getTraits", "()Ljava/util/List;", "setTraits", "graphql-java-tools"})
        public static final class Poodle
        extends Dog<PoodleTrait> {
            @NotNull
            private List<? extends PoodleTrait> traits;

            @Override
            @NotNull
            public List<PoodleTrait> getTraits() {
                return this.traits;
            }

            @Override
            public void setTraits(@NotNull List<? extends PoodleTrait> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.traits = list;
            }

            public Poodle(@NotNull List<? extends PoodleTrait> traits) {
                Intrinsics.checkNotNullParameter(traits, (String)"traits");
                this.traits = traits;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$EnumType;", "", "(Ljava/lang/String;I)V", "TEST", "graphql-java-tools"})
    public static final class EnumType
    extends Enum<EnumType> {
        public static final /* enum */ EnumType TEST;
        private static final /* synthetic */ EnumType[] $VALUES;

        static {
            EnumType[] enumTypeArray = new EnumType[1];
            EnumType[] enumTypeArray2 = enumTypeArray;
            enumTypeArray[0] = TEST = new EnumType();
            $VALUES = enumTypeArray;
        }

        public static EnumType[] values() {
            return (EnumType[])$VALUES.clone();
        }

        public static EnumType valueOf(String string) {
            return Enum.valueOf(EnumType.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$QueryWithIdResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getId", "", "graphql-java-tools"})
    public static final class QueryWithIdResolver
    implements GraphQLQueryResolver {
        @Nullable
        public final String getId() {
            return null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$Filter;", "", "()V", "filter", "", "graphql-java-tools"})
    public static final class Filter {
        @Nullable
        public final String filter() {
            return null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomGenericWrapper;", "T", "V", "", "()V", "graphql-java-tools"})
    public static final class CustomGenericWrapper<T, V> {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$Obj;", "", "()V", "name", "", "graphql-java-tools"})
    public static final class Obj {
        @Nullable
        public final Void name() {
            return null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$AnotherObj;", "", "()V", "key", "", "graphql-java-tools"})
    public static final class AnotherObj {
        @Nullable
        public final Void key() {
            return null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$RootObj;", "", "()V", "graphql-java-tools"})
    public static final class RootObj {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$ProxiedResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "test", "", "", "graphql-java-tools"})
    public static final class ProxiedResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<String> test() {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum;", "", "(Ljava/lang/String;I)V", "FOO", "graphql-java-tools"})
    public static final class CustomEnum
    extends Enum<CustomEnum> {
        public static final /* enum */ CustomEnum FOO;
        private static final /* synthetic */ CustomEnum[] $VALUES;

        static {
            CustomEnum[] customEnumArray = new CustomEnum[1];
            CustomEnum[] customEnumArray2 = customEnumArray;
            customEnumArray[0] = FOO = new FOO("FOO", 0);
            $VALUES = customEnumArray;
        }

        private CustomEnum() {
        }

        public /* synthetic */ CustomEnum(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static CustomEnum[] values() {
            return (CustomEnum[])$VALUES.clone();
        }

        public static CustomEnum valueOf(String string) {
            return Enum.valueOf(CustomEnum.class, string);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum$FOO;", "Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum;", "toString", "", "graphql-java-tools"})
        static final class FOO
        extends CustomEnum {
            @NotNull
            public String toString() {
                return "Bar";
            }

            /*
             * WARNING - void declaration
             */
            FOO() {
                void var1_1;
            }
        }
    }
}

