/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.resolver;

import graphql.kickstart.tools.GenericType;
import graphql.kickstart.tools.SchemaClassScanner;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TypeClassMatcher;
import graphql.kickstart.tools.resolver.FieldResolver;
import graphql.kickstart.tools.resolver.FieldResolverScanner;
import graphql.kickstart.tools.resolver.PropertyFieldResolverDataFetcher;
import graphql.language.FieldDefinition;
import graphql.language.Type;
import graphql.schema.DataFetcher;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/resolver/PropertyFieldResolver;", "Lgraphql/kickstart/tools/resolver/FieldResolver;", "field", "Lgraphql/language/FieldDefinition;", "search", "Lgraphql/kickstart/tools/resolver/FieldResolverScanner$Search;", "options", "Lgraphql/kickstart/tools/SchemaParserOptions;", "property", "Ljava/lang/reflect/Field;", "(Lgraphql/language/FieldDefinition;Lgraphql/kickstart/tools/resolver/FieldResolverScanner$Search;Lgraphql/kickstart/tools/SchemaParserOptions;Ljava/lang/reflect/Field;)V", "createDataFetcher", "Lgraphql/schema/DataFetcher;", "scanForMatches", "", "Lgraphql/kickstart/tools/TypeClassMatcher$PotentialMatch;", "toString", "", "graphql-java-tools"})
public final class PropertyFieldResolver
extends FieldResolver {
    @NotNull
    private final Field property;

    public PropertyFieldResolver(@NotNull FieldDefinition field, @NotNull FieldResolverScanner.Search search, @NotNull SchemaParserOptions options, @NotNull Field property) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Class<?> clazz = property.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"property.declaringClass");
        super(field, search, options, clazz);
        this.property = property;
    }

    @Override
    @NotNull
    public DataFetcher<?> createDataFetcher() {
        return new PropertyFieldResolverDataFetcher(this.getSourceResolver(), this.property);
    }

    @Override
    @NotNull
    public List<TypeClassMatcher.PotentialMatch> scanForMatches() {
        Object object = this.getField().getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"field.type");
        Type type = object;
        object = this.property.getGenericType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"property.genericType");
        Object object2 = object;
        GenericType.RelativeTo relativeTo = this.getGenericType();
        object = this.property.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"property.toString()");
        return CollectionsKt.listOf((Object)TypeClassMatcher.PotentialMatch.Companion.returnValue(type, (java.lang.reflect.Type)object2, relativeTo, new SchemaClassScanner.FieldTypeReference((String)object)));
    }

    @NotNull
    public String toString() {
        return "PropertyFieldResolver{property=" + this.property + '}';
    }
}

