/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.RelayConnectionTest;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest;", "", "()V", "should compile relay schema when not using @connection directive", "", "should compile relay schema when using @connection directive", "AnotherType", "QueryResolver", "User", "graphql-java-tools"})
public final class RelayConnectionTest {
    @Test
    public final void should compile relay schema when not using @connection directive() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users(first: Int, after: String): UserConnection\n                    otherTypes: AnotherTypeConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                    pageInfo: PageInfo!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String\n                }\n                \n                type PageInfo {\n                    hasNextPage: Boolean\n                }\n                \n                type AnotherTypeConnection {\n                    edges: [AnotherTypeEdge!]!\n                }\n                \n                type AnotherTypeEdge {\n                    node: AnotherType!\n                }\n                \n                type AnotherType {\n                    echo: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                users {\n                    edges {\n                        node {\n                            id\n                            name\n                        }\n                    }\n                }\n                otherTypes {\n                    edges {\n                        node {\n                            echo\n                        }\n                    }\n                }\n            }\n            ");
        Pair[] pairArray = new Pair[2];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"Luke")};
        pairArray[0] = TuplesKt.to((Object)"users", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair[])pairArray2)))))));
        pairArray[1] = TuplesKt.to((Object)"otherTypes", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"echo", (Object)"echo-o-o"))))))));
        Map expected = MapsKt.mapOf((Pair[])pairArray);
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should compile relay schema when using @connection directive() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("RelayConnection.graphqls").resolvers(graphQLResolverArray).dictionary(User.class).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)gql, (String)"gql");
        TestUtilsKt.assertNoGraphQlErrors$default(gql, null, null, should compile relay schema when using @connection directive.1.INSTANCE, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J-\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "otherTypes", "Lgraphql/relay/Connection;", "Lgraphql/kickstart/tools/RelayConnectionTest$AnotherType;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "users", "Lgraphql/kickstart/tools/RelayConnectionTest$User;", "first", "", "after", "", "(Ljava/lang/Integer;Ljava/lang/String;Lgraphql/schema/DataFetchingEnvironment;)Lgraphql/relay/Connection;", "graphql-java-tools"})
    private static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> users(@Nullable Integer first, @Nullable String after, @NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new User(1L, "Luke"))).get(env);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"SimpleListConnection(lis\u2026er(1L, \"Luke\"))).get(env)");
            return connection;
        }

        @NotNull
        public final Connection<AnotherType> otherTypes(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new AnotherType("echo-o-o"))).get(env);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"SimpleListConnection(lis\u2026pe(\"echo-o-o\"))).get(env)");
            return connection;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$User;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class User {
        private final long id;
        @NotNull
        private final String name;

        public User(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final User copy(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new User(id, name);
        }

        public static /* synthetic */ User copy$default(User user, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = user.id;
            }
            if ((n & 2) != 0) {
                string = user.name;
            }
            return user.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "User(id=" + this.id + ", name=" + this.name + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof User)) {
                return false;
            }
            User user = (User)other;
            if (this.id != user.id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)user.name);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$AnotherType;", "", "echo", "", "(Ljava/lang/String;)V", "getEcho", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class AnotherType {
        @NotNull
        private final String echo;

        public AnotherType(@NotNull String echo) {
            Intrinsics.checkNotNullParameter((Object)echo, (String)"echo");
            this.echo = echo;
        }

        @NotNull
        public final String getEcho() {
            return this.echo;
        }

        @NotNull
        public final String component1() {
            return this.echo;
        }

        @NotNull
        public final AnotherType copy(@NotNull String echo) {
            Intrinsics.checkNotNullParameter((Object)echo, (String)"echo");
            return new AnotherType(echo);
        }

        public static /* synthetic */ AnotherType copy$default(AnotherType anotherType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = anotherType.echo;
            }
            return anotherType.copy(string);
        }

        @NotNull
        public String toString() {
            return "AnotherType(echo=" + this.echo + ')';
        }

        public int hashCode() {
            return this.echo.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnotherType)) {
                return false;
            }
            AnotherType anotherType = (AnotherType)other;
            return Intrinsics.areEqual((Object)this.echo, (Object)anotherType.echo);
        }
    }
}

