/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.EnumListParameterTest;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest;", "", "()V", "gql", "Lgraphql/GraphQL;", "schema", "Lgraphql/schema/GraphQLSchema;", "query with parameter type list of enums should resolve correctly", "", "Country", "QueryResolver", "Region", "graphql-java-tools"})
public final class EnumListParameterTest {
    @NotNull
    private final GraphQLSchema schema;
    @NotNull
    private final GraphQL gql;

    public EnumListParameterTest() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()};
        this.schema = SchemaParser.Companion.newParser().schemaString("\n            type Query {\n                countries(regions: [Region!]!): [Country!]!\n            }\n    \n            enum Region {\n                EUROPE\n                ASIA\n            }\n    \n            type Country {\n                code: String!\n                name: String!\n                regions: [Region!]\n            }\n            ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"newGraphQL(schema)\n     \u2026ategy())\n        .build()");
        this.gql = graphQL;
    }

    @Test
    public final void query with parameter type list of enums should resolve correctly() {
        Object[] objectArray = new String[]{"EUROPE", "ASIA"};
        Map data2 = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, MapsKt.mapOf((Pair)TuplesKt.to((Object)"regions", (Object)SetsKt.setOf((Object[])objectArray))), null, query with parameter type list of enums should resolve correctly.data.1.INSTANCE, 4, null);
        TestUtilsKt.assertEquals(data2.get("countries"), CollectionsKt.emptyList());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getCountries", "", "Lgraphql/kickstart/tools/EnumListParameterTest$Country;", "regions", "Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "graphql-java-tools"})
    public static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Set<Country> getCountries(@NotNull Set<? extends Region> regions) {
            Intrinsics.checkNotNullParameter(regions, (String)"regions");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$Country;", "", "()V", "code", "", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "name", "getName", "setName", "regions", "", "Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "getRegions", "()Ljava/util/List;", "setRegions", "(Ljava/util/List;)V", "graphql-java-tools"})
    public static final class Country {
        @Nullable
        private String code;
        @Nullable
        private String name;
        @Nullable
        private List<? extends Region> regions;

        @Nullable
        public final String getCode() {
            return this.code;
        }

        public final void setCode(@Nullable String string) {
            this.code = string;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final List<Region> getRegions() {
            return this.regions;
        }

        public final void setRegions(@Nullable List<? extends Region> list) {
            this.regions = list;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "", "(Ljava/lang/String;I)V", "EUROPE", "ASIA", "graphql-java-tools"})
    public static final class Region
    extends Enum<Region> {
        public static final /* enum */ Region EUROPE = new Region();
        public static final /* enum */ Region ASIA = new Region();
        private static final /* synthetic */ Region[] $VALUES;

        public static Region[] values() {
            return (Region[])$VALUES.clone();
        }

        public static Region valueOf(String value) {
            return Enum.valueOf(Region.class, value);
        }

        static {
            $VALUES = regionArray = new Region[]{Region.EUROPE, Region.ASIA};
        }
    }
}

