/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.kickstart.tools.GraphQLMutationResolver;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaClassScannerError;
import graphql.kickstart.tools.SchemaError;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.SchemaParserTest;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.aop.framework.ProxyFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\"\u0018\u00002\u00020\u0001:\n\u001e\u001f !\"#$%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\b\u0010\f\u001a\u00020\u0006H\u0007J\b\u0010\r\u001a\u00020\u0006H\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0007J\b\u0010\u000f\u001a\u00020\u0006H\u0007J\b\u0010\u0010\u001a\u00020\u0006H\u0007J\b\u0010\u0011\u001a\u00020\u0006H\u0007J\b\u0010\u0012\u001a\u00020\u0006H\u0007J\b\u0010\u0013\u001a\u00020\u0006H\u0007J\b\u0010\u0014\u001a\u00020\u0006H\u0007J\b\u0010\u0015\u001a\u00020\u0006H\u0007J\b\u0010\u0016\u001a\u00020\u0006H\u0007J\b\u0010\u0017\u001a\u00020\u0006H\u0007J\b\u0010\u0018\u001a\u00020\u0006H\u0007J\b\u0010\u0019\u001a\u00020\u0006H\u0007J\b\u0010\u001a\u001a\u00020\u0006H\u0007J\b\u0010\u001b\u001a\u00020\u0006H\u0007J\b\u0010\u001c\u001a\u00020\u0006H\u0007J\b\u0010\u001d\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgraphql/kickstart/tools/SchemaParserTest;", "", "()V", "builder", "Lgraphql/kickstart/tools/SchemaParserBuilder;", "NonNull and nullable input arguments should resolve to GraphQLInputObjectType", "", "allow circular relations in input objects", "builder doesn't throw FileNotFound exception when file is present", "builder throws FileNotFound exception when file is missing", "interface implementing an interface should have non-empty interface list", "parser handles enums with overridden toString method", "parser handles spring AOP proxied resolvers by default", "parser should allow setting custom generic wrappers", "parser should allow turning off default generic wrappers", "parser should include schema descriptions when declared", "parser should include source location for field definition", "parser should include source location for field definition when loaded from single classpath file", "parser should not use comments for descriptions", "parser should parse correctly when Query resolver is given", "parser should parse correctly when multiple query resolvers are given", "parser should parse correctly when multiple resolvers for the same data type are given", "parser should return null schema description when not declared", "parser should throw descriptive exception when object is used as input type incorrectly", "parser should use comments for descriptions", "parser throws ResolverError when Query resolver is given without correct method", "parser throws SchemaError when Query resolver is missing", "setup", "support enum types if only used as input type", "support enum types if only used in input Map", "AnotherObj", "CustomEnum", "CustomGenericWrapper", "EnumType", "Filter", "MultiLevelInterfaceResolver", "Obj", "ProxiedResolver", "QueryWithIdResolver", "RootObj", "graphql-java-tools"})
public final class SchemaParserTest {
    private SchemaParserBuilder builder;

    @Before
    public final void setup() {
        this.builder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ");
    }

    @Test(expected=FileNotFoundException.class)
    public final void builder throws FileNotFound exception when file is missing() {
        SchemaParserBuilder schemaParserBuilder = this.builder;
        if (schemaParserBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            schemaParserBuilder = null;
        }
        schemaParserBuilder.file("/404").build();
    }

    @Test
    public final void builder doesn't throw FileNotFound exception when file is present() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String getId() {
                return "1";
            }
        }};
        SchemaParser.Companion.newParser().file("Test.graphqls").resolvers(graphQLResolverArray).build();
    }

    @Test(expected=SchemaClassScannerError.class)
    public final void parser throws SchemaError when Query resolver is missing() {
        SchemaParserBuilder schemaParserBuilder = this.builder;
        if (schemaParserBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            schemaParserBuilder = null;
        }
        schemaParserBuilder.build().makeExecutableSchema();
    }

    @Test(expected=FieldResolverError.class)
    public final void parser throws ResolverError when Query resolver is given without correct method() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when Query resolver is given() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final int get(int i) {
                return i;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    get(int: Int!): Int!\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when multiple query resolvers are given() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final Obj getObj() {
                return new Obj();
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final AnotherObj getAnotherObj() {
                return new AnotherObj();
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Obj {\n                    name: String\n                }\n    \n                type AnotherObj {\n                    key: String\n                }\n    \n                type Query {\n                    obj: Obj\n                    anotherObj: AnotherObj\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void parser should parse correctly when multiple resolvers for the same data type are given() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final RootObj getRootObj() {
                return new RootObj();
            }
        }, (GraphQLResolver)new GraphQLResolver<RootObj>(){

            @NotNull
            public final Obj getObj(@NotNull RootObj rootObj) {
                Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
                return new Obj();
            }
        }, (GraphQLResolver)new GraphQLResolver<RootObj>(){

            @NotNull
            public final AnotherObj getAnotherObj(@NotNull RootObj rootObj) {
                Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
                return new AnotherObj();
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type RootObj {\n                    obj: Obj\n                    anotherObj: AnotherObj\n                }\n                \n                type Obj {\n                    name: String\n                }\n                \n                type AnotherObj {\n                    key: String\n                }\n                \n                type Query {\n                    rootObj: RootObj\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void parser should allow setting custom generic wrappers() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final CustomGenericWrapper<Integer, Obj> one() {
                return null;
            }

            @Nullable
            public final Obj two() {
                return null;
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    one: Object!\n                    two: Object!\n                }\n                \n                type Object {\n                    name: String!\n                }\n                ").resolvers(graphQLResolverArray);
        graphQLResolverArray = new SchemaParserOptions.GenericWrapper[]{new SchemaParserOptions.GenericWrapper(Reflection.getOrCreateKotlinClass(CustomGenericWrapper.class), 1)};
        schemaParserBuilder.options(SchemaParserOptions.Companion.newOptions().genericWrappers((SchemaParserOptions.GenericWrapper[])graphQLResolverArray).build()).build().makeExecutableSchema();
    }

    @Test(expected=SchemaClassScannerError.class)
    public final void parser should allow turning off default generic wrappers() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final Future<Obj> one() {
                return null;
            }

            @Nullable
            public final Obj two() {
                return null;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    one: Object!\n                    two: Object!\n                }\n                \n                type Object {\n                    toString: String!\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().useDefaultGenericWrappers(false).build()).build().makeExecutableSchema();
    }

    @Test
    public final void parser should throw descriptive exception when object is used as input type incorrectly() {
        Assert.assertThrows((String)"Was a type only permitted for object types incorrectly used as an input type, or vice-versa", SchemaError.class, SchemaParserTest::parser_should_throw_descriptive_exception_when_object_is_used_as_input_type_incorrectly$lambda$0);
    }

    @Test
    public final void parser handles spring AOP proxied resolvers by default() {
        Object object = new ProxyFactory((Object)new ProxiedResolver()).getProxy();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type graphql.kickstart.tools.GraphQLQueryResolver");
        GraphQLQueryResolver resolver2 = (GraphQLQueryResolver)object;
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)resolver2};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    test: [String]\n                }\n                ").resolvers(graphQLResolverArray).build();
    }

    @Test
    public final void parser handles enums with overridden toString method() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final CustomEnum customEnum() {
                return null;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                enum CustomEnum {\n                    FOO\n                }\n                \n                type Query {\n                    customEnum: CustomEnum\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void parser should include source location for field definition() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryWithIdResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("type Query {\n    id: ID!\n}").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        FieldDefinition fieldDefinition = schema2.getObjectType("Query").getFieldDefinition("id").getDefinition();
        Intrinsics.checkNotNull((Object)fieldDefinition);
        SourceLocation sourceLocation = fieldDefinition.getSourceLocation();
        TestUtilsKt.assertNotNull(sourceLocation);
        TestUtilsKt.assertEquals(sourceLocation.getLine(), 2);
        TestUtilsKt.assertEquals(sourceLocation.getColumn(), 5);
        TestUtilsKt.assertNull(sourceLocation.getSourceName());
    }

    @Test
    public final void parser should include source location for field definition when loaded from single classpath file() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryWithIdResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("Test.graphqls").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        FieldDefinition fieldDefinition = schema2.getObjectType("Query").getFieldDefinition("id").getDefinition();
        Intrinsics.checkNotNull((Object)fieldDefinition);
        SourceLocation sourceLocation = fieldDefinition.getSourceLocation();
        TestUtilsKt.assertNotNull(sourceLocation);
        TestUtilsKt.assertEquals(sourceLocation.getLine(), 2);
        TestUtilsKt.assertEquals(sourceLocation.getColumn(), 3);
        TestUtilsKt.assertEquals(sourceLocation.getSourceName(), "Test.graphqls");
    }

    @Test
    public final void support enum types if only used as input type() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean save(@NotNull support enum types if only used as input type.SaveInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return false;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query { test: Boolean }\n                        \n                type Mutation {\n                    save(input: SaveInput!): Boolean\n                }\n                \n                input SaveInput {\n                    type: EnumType!\n                }\n                \n                enum EnumType {\n                    TEST\n                }\n                ").resolvers(graphQLResolverArray).dictionary(Reflection.getOrCreateKotlinClass(EnumType.class)).build().makeExecutableSchema();
    }

    @Test
    public final void support enum types if only used in input Map() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean save(@NotNull Map<?, ?> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                return false;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query { test: Boolean }\n                        \n                type Mutation {\n                    save(input: SaveInput!): Boolean\n                }\n                \n                input SaveInput {\n                    age: Int\n                    type: EnumType!\n                }\n                \n                enum EnumType {\n                    TEST\n                }\n                ").resolvers(graphQLResolverArray).dictionary(Reflection.getOrCreateKotlinClass(EnumType.class)).build().makeExecutableSchema();
    }

    @Test
    public final void allow circular relations in input objects() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLMutationResolver(){

            public final boolean test(@NotNull allow circular relations in input objects.A a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                return true;
            }

            public final boolean testC(@NotNull allow circular relations in input objects.C c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                return true;
            }
        }, (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean test() {
                return false;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                input A {\n                    id: ID!\n                    b: B\n                }\n                input B {\n                    id: ID!\n                    a: A\n                }\n                input C {\n                    id: ID!\n                    c: C\n                }\n                type Query { test: Boolean }\n                type Mutation {\n                    test(input: A!): Boolean\n                    testC(input: C!): Boolean\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void interface implementing an interface should have non-empty interface list() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new MultiLevelInterfaceResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                interface Trait {\n                    id: ID!\n                }\n                interface MammalTrait implements Trait {\n                    id: ID!\n                }\n                type PoodleTrait implements Trait & MammalTrait {\n                    id: ID!\n                }\n\n                interface Animal {\n                    id: ID!\n                    traits: [Trait]\n                }\n                interface Dog implements Animal {\n                    id: ID!\n                    traits: [MammalTrait]\n                }\n                type Poodle implements Animal & Dog {\n                    id: ID!\n                    traits: [PoodleTrait]\n                }\n\n                type Query { test: [Poodle] }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("Trait");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        GraphQLInterfaceType traitInterface = (GraphQLInterfaceType)graphQLType;
        GraphQLType graphQLType2 = schema2.getType("Animal");
        Intrinsics.checkNotNull((Object)graphQLType2, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        GraphQLInterfaceType animalInterface = (GraphQLInterfaceType)graphQLType2;
        GraphQLType graphQLType3 = schema2.getType("MammalTrait");
        Intrinsics.checkNotNull((Object)graphQLType3, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        GraphQLInterfaceType mammalTraitInterface = (GraphQLInterfaceType)graphQLType3;
        GraphQLType graphQLType4 = schema2.getType("Dog");
        Intrinsics.checkNotNull((Object)graphQLType4, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInterfaceType");
        GraphQLInterfaceType dogInterface = (GraphQLInterfaceType)graphQLType4;
        GraphQLType graphQLType5 = schema2.getType("Poodle");
        Intrinsics.checkNotNull((Object)graphQLType5, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        GraphQLObjectType poodleObject = (GraphQLObjectType)graphQLType5;
        GraphQLType graphQLType6 = schema2.getType("PoodleTrait");
        Intrinsics.checkNotNull((Object)graphQLType6, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        GraphQLObjectType poodleTraitObject = (GraphQLObjectType)graphQLType6;
        Object[] objectArray = new GraphQLInterfaceType[]{dogInterface, animalInterface};
        boolean bl = poodleObject.getInterfaces().containsAll(CollectionsKt.listOf((Object[])objectArray));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray2 = new GraphQLInterfaceType[]{mammalTraitInterface, traitInterface};
        boolean bl2 = poodleTraitObject.getInterfaces().containsAll(CollectionsKt.listOf((Object[])objectArray2));
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl2 = dogInterface.getInterfaces().contains(animalInterface);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl2 = mammalTraitInterface.getInterfaces().contains(traitInterface);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        InterfaceTypeDefinition interfaceTypeDefinition = traitInterface.getDefinition();
        Intrinsics.checkNotNull((Object)interfaceTypeDefinition);
        bl2 = interfaceTypeDefinition.getImplements().isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        InterfaceTypeDefinition interfaceTypeDefinition2 = animalInterface.getDefinition();
        Intrinsics.checkNotNull((Object)interfaceTypeDefinition2);
        bl2 = interfaceTypeDefinition2.getImplements().isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void NonNull and nullable input arguments should resolve to GraphQLInputObjectType() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean testNonNullable(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return false;
            }

            public final boolean testNullable(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return false;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testNonNullable(filter: Filter!): Boolean\n                    testNullable(filter: Filter): Boolean\n                }\n        \n                input Filter {\n                    filter: String\n                }\n                ").resolvers(graphQLResolverArray).directiveWiring(new SchemaDirectiveWiring(){

            @NotNull
            public GraphQLArgument onArgument(@NotNull SchemaDirectiveWiringEnvironment<GraphQLArgument> environment) {
                Intrinsics.checkNotNullParameter(environment, (String)"environment");
                if (((GraphQLArgument)environment.getElement()).getType() instanceof GraphQLNonNull) {
                    GraphQLInputType graphQLInputType = ((GraphQLArgument)environment.getElement()).getType();
                    Intrinsics.checkNotNull((Object)graphQLInputType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLNonNull");
                    boolean bl = ((GraphQLNonNull)graphQLInputType).getWrappedType() instanceof GraphQLInputObjectType;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                }
                GraphQLDirectiveContainer graphQLDirectiveContainer = environment.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)graphQLDirectiveContainer, (String)"environment.element");
                return (GraphQLArgument)graphQLDirectiveContainer;
            }
        }).build().makeExecutableSchema();
        List list = schema2.getObjectType("Query").getFieldDefinition("testNonNullable").getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schema.getObjectType(\"Qu\u2026\")\n            .arguments");
        GraphQLArgument testNonNullableArgument = (GraphQLArgument)CollectionsKt.first((List)list);
        List list2 = schema2.getObjectType("Query").getFieldDefinition("testNullable").getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"schema.getObjectType(\"Qu\u2026\")\n            .arguments");
        GraphQLArgument testNullableArgument = (GraphQLArgument)CollectionsKt.first((List)list2);
        boolean bl = testNonNullableArgument.getType() instanceof GraphQLNonNull;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        GraphQLInputType graphQLInputType = testNonNullableArgument.getType();
        Intrinsics.checkNotNull((Object)graphQLInputType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLNonNull");
        bl = ((GraphQLNonNull)graphQLInputType).getWrappedType() instanceof GraphQLInputObjectType;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = testNullableArgument.getType() instanceof GraphQLInputObjectType;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void parser should use comments for descriptions() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    \"description\"\n                    description: String\n                    #comment\n                    comment: String\n                    omitted: String\n                    \"description\"\n                    #comment\n                    both: String\n                    \"\"\n                    empty: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().allowUnimplementedResolvers(true).build()).build().makeExecutableSchema();
        GraphQLObjectType queryType = schema2.getObjectType("Query");
        TestUtilsKt.assertEquals(queryType.getFieldDefinition("description").getDescription(), "description");
        TestUtilsKt.assertEquals(queryType.getFieldDefinition("comment").getDescription(), "comment");
        TestUtilsKt.assertNull(queryType.getFieldDefinition("omitted").getDescription());
        TestUtilsKt.assertEquals(queryType.getFieldDefinition("both").getDescription(), "description");
        TestUtilsKt.assertEquals(queryType.getFieldDefinition("empty").getDescription(), "");
    }

    @Test
    public final void parser should not use comments for descriptions() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    \"description\"\n                    description: String\n                    #comment\n                    comment: String\n                    omitted: String\n                    \"description\"\n                    #comment\n                    both: String\n                    \"\"\n                    empty: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().useCommentsForDescriptions(false).allowUnimplementedResolvers(true).build()).build().makeExecutableSchema();
        TestUtilsKt.assertEquals(schema2.getQueryType().getFieldDefinition("description").getDescription(), "description");
        TestUtilsKt.assertNull(schema2.getQueryType().getFieldDefinition("comment").getDescription());
        TestUtilsKt.assertNull(schema2.getQueryType().getFieldDefinition("omitted").getDescription());
        TestUtilsKt.assertEquals(schema2.getQueryType().getFieldDefinition("both").getDescription(), "description");
        TestUtilsKt.assertEquals(schema2.getQueryType().getFieldDefinition("empty").getDescription(), "");
    }

    @Test
    public final void parser should include schema descriptions when declared() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                \"This is a schema level description\"\n                schema {\n                  query: SubstituteQuery\n                }\n\n                type SubstituteQuery {\n                    description: String\n                    comment: String\n                    omitted: String\n                    both: String\n                    empty: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().allowUnimplementedResolvers(true).build()).build().makeExecutableSchema();
        TestUtilsKt.assertEquals(schema2.getDescription(), "This is a schema level description");
    }

    @Test
    public final void parser should return null schema description when not declared() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){}};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                schema {\n                  query: SubstituteQuery\n                }\n\n                type SubstituteQuery {\n                    description: String\n                    comment: String\n                    omitted: String\n                    both: String\n                    empty: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().allowUnimplementedResolvers(true).build()).build().makeExecutableSchema();
        TestUtilsKt.assertNull(schema2.getDescription());
    }

    private static final void parser_should_throw_descriptive_exception_when_object_is_used_as_input_type_incorrectly$lambda$0() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @Nullable
            public final List<String> name(@NotNull Filter filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                return null;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                    type Query {\n                        name(filter: Filter): [String]\n                    }\n                    \n                    type Filter {\n                        filter: String\n                    }\n                    ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\f"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "test", "", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Poodle;", "Animal", "Dog", "MammalTrait", "Poodle", "PoodleTrait", "Trait", "graphql-java-tools"})
    public static final class MultiLevelInterfaceResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<Poodle> test() {
            return CollectionsKt.emptyList();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface Trait {
            @NotNull
            public String getId();

            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface MammalTrait
        extends Trait {
            @Override
            @NotNull
            public String getId();

            @Override
            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$PoodleTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static interface PoodleTrait
        extends MammalTrait {
            @Override
            @NotNull
            public String getId();

            @Override
            public void setId(@NotNull String var1);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Animal;", "T", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Trait;", "", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "traits", "", "getTraits", "()Ljava/util/List;", "setTraits", "(Ljava/util/List;)V", "graphql-java-tools"})
        public static abstract class Animal<T extends Trait> {
            @Nullable
            private String id;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }

            @NotNull
            public abstract List<T> getTraits();

            public abstract void setTraits(@NotNull List<? extends T> var1);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004R\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Dog;", "T", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$MammalTrait;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Animal;", "()V", "traits", "", "getTraits", "()Ljava/util/List;", "setTraits", "(Ljava/util/List;)V", "graphql-java-tools"})
        public static abstract class Dog<T extends MammalTrait>
        extends Animal<T> {
            @Override
            @NotNull
            public abstract List<T> getTraits();

            @Override
            public abstract void setTraits(@NotNull List<? extends T> var1);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Poodle;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$Dog;", "Lgraphql/kickstart/tools/SchemaParserTest$MultiLevelInterfaceResolver$PoodleTrait;", "traits", "", "(Ljava/util/List;)V", "getTraits", "()Ljava/util/List;", "setTraits", "graphql-java-tools"})
        public static final class Poodle
        extends Dog<PoodleTrait> {
            @NotNull
            private List<? extends PoodleTrait> traits;

            public Poodle(@NotNull List<? extends PoodleTrait> traits) {
                Intrinsics.checkNotNullParameter(traits, (String)"traits");
                this.traits = traits;
            }

            @Override
            @NotNull
            public List<PoodleTrait> getTraits() {
                return this.traits;
            }

            @Override
            public void setTraits(@NotNull List<? extends PoodleTrait> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.traits = list;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$EnumType;", "", "(Ljava/lang/String;I)V", "TEST", "graphql-java-tools"})
    public static final class EnumType
    extends Enum<EnumType> {
        public static final /* enum */ EnumType TEST = new EnumType();
        private static final /* synthetic */ EnumType[] $VALUES;

        public static EnumType[] values() {
            return (EnumType[])$VALUES.clone();
        }

        public static EnumType valueOf(String value) {
            return Enum.valueOf(EnumType.class, value);
        }

        static {
            $VALUES = enumTypeArray = new EnumType[]{EnumType.TEST};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$QueryWithIdResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getId", "", "graphql-java-tools"})
    public static final class QueryWithIdResolver
    implements GraphQLQueryResolver {
        @Nullable
        public final String getId() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$Filter;", "", "()V", "filter", "", "graphql-java-tools"})
    public static final class Filter {
        @Nullable
        public final String filter() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomGenericWrapper;", "T", "V", "", "()V", "graphql-java-tools"})
    public static final class CustomGenericWrapper<T, V> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$Obj;", "", "()V", "name", "", "graphql-java-tools"})
    public static final class Obj {
        @Nullable
        public final Void name() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$AnotherObj;", "", "()V", "key", "", "graphql-java-tools"})
    public static final class AnotherObj {
        @Nullable
        public final Void key() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$RootObj;", "", "()V", "graphql-java-tools"})
    public static final class RootObj {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$ProxiedResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "test", "", "", "graphql-java-tools"})
    public static final class ProxiedResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<String> test() {
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum;", "", "(Ljava/lang/String;I)V", "FOO", "graphql-java-tools"})
    public static final class CustomEnum
    extends Enum<CustomEnum> {
        public static final /* enum */ CustomEnum FOO = new FOO("FOO", 0);
        private static final /* synthetic */ CustomEnum[] $VALUES;

        private CustomEnum() {
        }

        public static CustomEnum[] values() {
            return (CustomEnum[])$VALUES.clone();
        }

        public static CustomEnum valueOf(String value) {
            return Enum.valueOf(CustomEnum.class, value);
        }

        public /* synthetic */ CustomEnum(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = customEnumArray = new CustomEnum[]{CustomEnum.FOO};
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum$FOO;", "Lgraphql/kickstart/tools/SchemaParserTest$CustomEnum;", "toString", "", "graphql-java-tools"})
        static final class FOO
        extends CustomEnum {
            /*
             * WARNING - void declaration
             */
            FOO() {
                void var1_1;
            }

            @NotNull
            public String toString() {
                return "Bar";
            }
        }
    }
}

