/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.BuiltInIdTest;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/BuiltInIdTest;", "", "()V", "gql", "Lgraphql/GraphQL;", "schema", "Lgraphql/schema/GraphQLSchema;", "supports Long as ID as input", "", "supports UUID as ID as input", "supports list of Long as ID as input", "supports list of UUID as ID as input", "Item1", "Item2", "QueryWithLongItemResolver", "graphql-java-tools"})
public final class BuiltInIdTest {
    @NotNull
    private final GraphQLSchema schema;
    @NotNull
    private final GraphQL gql;

    public BuiltInIdTest() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new QueryWithLongItemResolver()};
        this.schema = SchemaParser.Companion.newParser().schemaString("\n            type Query {\n                itemByLongId(id: ID!): Item1!\n                itemsByLongIds(ids: [ID!]!): [Item1!]!\n                itemByUuidId(id: ID!): Item2!\n                itemsByUuidIds(ids: [ID!]!): [Item2!]!\n            }\n            \n            type Item1 {\n                id: ID!\n            }\n            \n            type Item2 {\n                id: ID!\n            }\n            ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"newGraphQL(schema)\n     \u2026ategy())\n        .build()");
        this.gql = graphQL;
    }

    @Test
    public final void supports Long as ID as input() {
        Map data2 = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, supports Long as ID as input.data.1.INSTANCE, 6, null);
        TestUtilsKt.assertEquals(data2.get("itemByLongId"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"1")));
    }

    @Test
    public final void supports list of Long as ID as input() {
        Map data2 = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, supports list of Long as ID as input.data.1.INSTANCE, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"1")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"2")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"3"))};
        TestUtilsKt.assertEquals(data2.get("itemsByLongIds"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void supports UUID as ID as input() {
        Map data2 = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, supports UUID as ID as input.data.1.INSTANCE, 6, null);
        TestUtilsKt.assertEquals(data2.get("itemByUuidId"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"00000000-0000-0000-0000-000000000000")));
    }

    @Test
    public final void supports list of UUID as ID as input() {
        Map data2 = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, supports list of UUID as ID as input.data.1.INSTANCE, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"00000000-0000-0000-0000-000000000000")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"11111111-1111-1111-1111-111111111111")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)"22222222-2222-2222-2222-222222222222"))};
        TestUtilsKt.assertEquals(data2.get("itemsByUuidIds"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/BuiltInIdTest$Item1;", "", "id", "", "(Ljava/lang/Long;)V", "getId", "()Ljava/lang/Long;", "setId", "Ljava/lang/Long;", "graphql-java-tools"})
    public static final class Item1 {
        @Nullable
        private Long id;

        public Item1(@Nullable Long id) {
            this.id = id;
        }

        public /* synthetic */ Item1(Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = null;
            }
            this(l);
        }

        @Nullable
        public final Long getId() {
            return this.id;
        }

        public final void setId(@Nullable Long l) {
            this.id = l;
        }

        public Item1() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/BuiltInIdTest$Item2;", "", "id", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "getId", "()Ljava/util/UUID;", "setId", "graphql-java-tools"})
    public static final class Item2 {
        @Nullable
        private UUID id;

        public Item2(@Nullable UUID id) {
            this.id = id;
        }

        public /* synthetic */ Item2(UUID uUID, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                uUID = null;
            }
            this(uUID);
        }

        @Nullable
        public final UUID getId() {
            return this.id;
        }

        public final void setId(@Nullable UUID uUID) {
            this.id = uUID;
        }

        public Item2() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a8\u0006\u000e"}, d2={"Lgraphql/kickstart/tools/BuiltInIdTest$QueryWithLongItemResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "itemByLongId", "Lgraphql/kickstart/tools/BuiltInIdTest$Item1;", "id", "", "itemByUuidId", "Lgraphql/kickstart/tools/BuiltInIdTest$Item2;", "Ljava/util/UUID;", "itemsByLongIds", "", "ids", "itemsByUuidIds", "graphql-java-tools"})
    @SourceDebugExtension(value={"SMAP\nBuiltInIdTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInIdTest.kt\ngraphql/kickstart/tools/BuiltInIdTest$QueryWithLongItemResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1549#2:115\n1620#2,3:116\n1549#2:119\n1620#2,3:120\n*S KotlinDebug\n*F\n+ 1 BuiltInIdTest.kt\ngraphql/kickstart/tools/BuiltInIdTest$QueryWithLongItemResolver\n*L\n106#1:115\n106#1:116,3\n108#1:119\n108#1:120,3\n*E\n"})
    public static final class QueryWithLongItemResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Item1 itemByLongId(long id) {
            return new Item1(id);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Item1> itemsByLongIds(@NotNull List<Long> ids) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Iterable $this$map$iv = ids;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Item1((long)it));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Item2 itemByUuidId(@NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new Item2(id);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Item2> itemsByUuidIds(@NotNull List<UUID> ids) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Iterable $this$map$iv = ids;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Item2((UUID)it));
            }
            return (List)destination$iv$iv;
        }
    }
}

