/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MissingFieldResolverTest;", "", "()V", "should call missing resolver data fetcher if provided", "", "should throw error when a field is missing", "TestMissingResolverDataFetcher", "graphql-java-tools"})
public final class MissingFieldResolverTest {
    @Test(expected=FieldResolverError.class)
    public final void should throw error when a field is missing() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String implementedField(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    implementedField(input: String): String\n                    missingField(input: Int): Int\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void should call missing resolver data fetcher if provided() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String implementedField(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    implementedField(input: String): String\n                    missingField(input: Int): Int\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().missingResolverDataFetcher((DataFetcher)new TestMissingResolverDataFetcher()).build()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute("\n            query {\n                implementedField(input: \"test-value\")\n                missingField(input: 1)\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"implementedField", (Object)"Optional[test-value]"), TuplesKt.to((Object)"missingField", (Object)1)};
        Map expected = MapsKt.mapOf((Pair[])pairArray);
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MissingFieldResolverTest$TestMissingResolverDataFetcher;", "Lgraphql/schema/DataFetcher;", "", "()V", "get", "env", "Lgraphql/schema/DataFetchingEnvironment;", "graphql-java-tools"})
    public static final class TestMissingResolverDataFetcher
    implements DataFetcher<Object> {
        @Nullable
        public Object get(@Nullable DataFetchingEnvironment env) {
            DataFetchingEnvironment dataFetchingEnvironment = env;
            return dataFetchingEnvironment != null ? dataFetchingEnvironment.getArgument("input") : null;
        }
    }
}

