/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\b\n\u000b\f\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/DirectiveTest;", "", "()V", "should apply @uppercase directive on field", "", "should apply @uppercase directive on object", "should apply multiple directives", "should apply repeated directive", "should compile schema with directive that has enum parameter", "should have access to applied directives through the data fetching environment", "AllowedDirective", "AllowedState", "Book", "DoubleDirective", "NameResolver", "QueryResolver", "UppercaseDirective", "UsersQueryResolver", "graphql-java-tools"})
public final class DirectiveTest {
    @Test
    public final void should apply @uppercase directive on field() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase on FIELD_DEFINITION\n                \n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String @uppercase\n                }\n                ").resolvers(graphQLResolverArray).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                users {\n                    edges {\n                        node {\n                            id\n                            name\n                        }\n                    }\n                }\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LUKE")};
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"users", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair[])pairArray))))))));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should apply @uppercase directive on object() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase on OBJECT\n                \n                type Query {\n                    user: User\n                }\n                \n                type User @uppercase {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                user {\n                    id\n                    name\n                }\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LUKE")};
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"user", (Object)MapsKt.mapOf((Pair[])pairArray)));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should apply multiple directives() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @double repeatable on FIELD_DEFINITION\n                directive @uppercase on FIELD_DEFINITION\n                \n                type Query {\n                    user: User\n                }\n                \n                type User {\n                    id: ID!\n                    name: String @uppercase @double\n                }\n                ").resolvers(graphQLResolverArray).directive("double", (SchemaDirectiveWiring)new DoubleDirective()).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                user {\n                    id\n                    name\n                }\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LUKELUKE")};
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"user", (Object)MapsKt.mapOf((Pair[])pairArray)));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should apply repeated directive() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @double repeatable on FIELD_DEFINITION\n                \n                type Query {\n                    user: User\n                }\n                \n                type User {\n                    id: ID!\n                    name: String @double @double\n                }\n                ").resolvers(graphQLResolverArray).directive("double", (SchemaDirectiveWiring)new DoubleDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                user {\n                    id\n                    name\n                }\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LukeLukeLukeLuke")};
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"user", (Object)MapsKt.mapOf((Pair[])pairArray)));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should have access to applied directives through the data fetching environment() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new NameResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase on OBJECT\n                \n                type Query {\n                    name: String @uppercase\n                }\n                \n                ").resolvers(graphQLResolverArray).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n            query {\n                name\n            }\n            ");
        Map expected = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"LUKE"));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, expected);
    }

    @Test
    public final void should compile schema with directive that has enum parameter() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new QueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @allowed(state: [AllowedState!]) on FIELD_DEFINITION\n                \n                enum AllowedState {\n                    ALLOWED\n                    DISALLOWED\n                }\n                \n                type Book {\n                    id: Int!\n                    name: String! @allowed(state: [ALLOWED])\n                }\n                \n                type Query {\n                    books: [Book!]\n                }\n                ").resolvers(graphQLResolverArray).directive("allowed", (SchemaDirectiveWiring)new AllowedDirective()).dictionary(Reflection.getOrCreateKotlinClass(AllowedState.class)).build().makeExecutableSchema();
        GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$AllowedDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "graphql-java-tools"})
    private static final class AllowedDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            return field;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$AllowedState;", "", "(Ljava/lang/String;I)V", "ALLOWED", "DISALLOWED", "graphql-java-tools"})
    private static final class AllowedState
    extends Enum<AllowedState> {
        public static final /* enum */ AllowedState ALLOWED = new AllowedState();
        public static final /* enum */ AllowedState DISALLOWED = new AllowedState();
        private static final /* synthetic */ AllowedState[] $VALUES;

        public static AllowedState[] values() {
            return (AllowedState[])$VALUES.clone();
        }

        public static AllowedState valueOf(String value) {
            return Enum.valueOf(AllowedState.class, value);
        }

        static {
            $VALUES = allowedStateArray = new AllowedState[]{AllowedState.ALLOWED, AllowedState.DISALLOWED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$Book;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class Book {
        private final long id;
        @NotNull
        private final String name;

        public Book(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Book copy(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Book(id, name);
        }

        public static /* synthetic */ Book copy$default(Book book, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = book.id;
            }
            if ((n & 2) != 0) {
                string = book.name;
            }
            return book.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "Book(id=" + this.id + ", name=" + this.name + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Book)) {
                return false;
            }
            Book book = (Book)other;
            if (this.id != book.id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)book.name);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$DoubleDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "graphql-java-tools"})
    private static final class DoubleDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
            FieldCoordinates parentType = FieldCoordinates.coordinates((GraphQLFieldsContainer)environment.getFieldsContainer(), (GraphQLFieldDefinition)environment.getFieldDefinition());
            DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
            DataFetcher wrappedDataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, DoubleDirective::onField$lambda$0);
            environment.getCodeRegistry().dataFetcher(parentType, wrappedDataFetcher);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            return field;
        }

        private static final Object onField$lambda$0(DataFetchingEnvironment dataFetchingEnvironment, Object value) {
            String string = value instanceof String ? (String)value : null;
            return string + string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$NameResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "name", "", "environment", "Lgraphql/schema/DataFetchingEnvironment;", "graphql-java-tools"})
    public static final class NameResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final String name(@NotNull DataFetchingEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            TestUtilsKt.assertNotNull(environment.getFieldDefinition().getAppliedDirective("uppercase"));
            TestUtilsKt.assertNotNull(environment.getFieldDefinition().getDirective("uppercase"));
            return "luke";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "books", "", "Lgraphql/kickstart/tools/DirectiveTest$Book;", "graphql-java-tools"})
    private static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final List<Book> books() {
            return CollectionsKt.listOf((Object)new Book(42L, "Test Book"));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0016\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UppercaseDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "onObject", "Lgraphql/schema/GraphQLObjectType;", "graphql-java-tools"})
    @SourceDebugExtension(value={"SMAP\nDirectiveTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectiveTest.kt\ngraphql/kickstart/tools/DirectiveTest$UppercaseDirective\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1855#2,2:369\n*S KotlinDebug\n*F\n+ 1 DirectiveTest.kt\ngraphql/kickstart/tools/DirectiveTest$UppercaseDirective\n*L\n307#1:369,2\n*E\n"})
    private static final class UppercaseDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLObjectType onObject(@NotNull SchemaDirectiveWiringEnvironment<GraphQLObjectType> environment) {
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLObjectType objectType = (GraphQLObjectType)environment.getElement();
            List list = objectType.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"objectType.fields");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GraphQLFieldDefinition field = (GraphQLFieldDefinition)element$iv;
                boolean bl = false;
                DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher((GraphQLFieldsContainer)objectType, field);
                DataFetcher wrappedDataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, UppercaseDirective::onObject$lambda$1$lambda$0);
                environment.getCodeRegistry().dataFetcher((GraphQLFieldsContainer)objectType, field, wrappedDataFetcher);
            }
            Intrinsics.checkNotNullExpressionValue((Object)objectType, (String)"objectType");
            return objectType;
        }

        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
            FieldCoordinates parentType = FieldCoordinates.coordinates((GraphQLFieldsContainer)environment.getFieldsContainer(), (GraphQLFieldDefinition)environment.getFieldDefinition());
            DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
            DataFetcher wrappedDataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, UppercaseDirective::onField$lambda$2);
            environment.setFieldDataFetcher(wrappedDataFetcher);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            return field;
        }

        private static final Object onObject$lambda$1$lambda$0(DataFetchingEnvironment dataFetchingEnvironment, Object value) {
            Object object;
            if (value instanceof String) {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                String string = ((String)value).toUpperCase(Locale.ROOT);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            } else {
                object = value;
            }
            return object;
        }

        private static final Object onField$lambda$2(DataFetchingEnvironment dataFetchingEnvironment, Object value) {
            String string;
            String string2 = value instanceof String ? (String)value : null;
            if (string2 != null) {
                String string3 = string2.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            } else {
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "user", "Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver$User;", "users", "Lgraphql/relay/Connection;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "User", "graphql-java-tools"})
    private static final class UsersQueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> users(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new User(1L, "Luke"))).get(env);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"SimpleListConnection(lis\u2026er(1L, \"Luke\"))).get(env)");
            return connection;
        }

        @NotNull
        public final User user() {
            return new User(1L, "Luke");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/DirectiveTest$UsersQueryResolver$User;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
        private static final class User {
            private final long id;
            @NotNull
            private final String name;

            public User(long id, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.id = id;
                this.name = name;
            }

            public final long getId() {
                return this.id;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final long component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.name;
            }

            @NotNull
            public final User copy(long id, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new User(id, name);
            }

            public static /* synthetic */ User copy$default(User user, long l, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    l = user.id;
                }
                if ((n & 2) != 0) {
                    string = user.name;
                }
                return user.copy(l, string);
            }

            @NotNull
            public String toString() {
                return "User(id=" + this.id + ", name=" + this.name + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.id);
                result = result * 31 + this.name.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof User)) {
                    return false;
                }
                User user = (User)other;
                if (this.id != user.id) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.name, (Object)user.name);
            }
        }
    }
}

