/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u0010"}, d2={"Lgraphql/kickstart/tools/DeprecatedDirectiveTest;", "", "()V", "should apply @deprecated directive on argument with custom reason", "", "should apply @deprecated directive on argument with default reason", "should apply @deprecated directive on directive argument with custom reason", "should apply @deprecated directive on directive argument with default reason", "should apply @deprecated directive on enum value with custom reason", "should apply @deprecated directive on enum value with default reason", "should apply @deprecated directive on input field with custom reason", "should apply @deprecated directive on input field with default reason", "should apply @deprecated directive on output field with custom reason", "should apply @deprecated directive on output field with default reason", "UserType", "UsersQueryResolver", "graphql-java-tools"})
public final class DeprecatedDirectiveTest {
    @Test
    public final void should apply @deprecated directive on output field with default reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String @deprecated\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("User");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        GraphQLObjectType userType = (GraphQLObjectType)graphQLType;
        GraphQLFieldDefinition nameDefinition = userType.getField("name");
        boolean bl = nameDefinition.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(nameDefinition.getDeprecationReason(), "No longer supported");
    }

    @Test
    public final void should apply @deprecated directive on output field with custom reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String @deprecated(reason: \"Use firstName and lastName instead\")\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("User");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
        GraphQLObjectType userType = (GraphQLObjectType)graphQLType;
        GraphQLFieldDefinition nameDefinition = userType.getField("name");
        boolean bl = nameDefinition.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(nameDefinition.getDeprecationReason(), "Use firstName and lastName instead");
    }

    @Test
    public final void should apply @deprecated directive on enum value with default reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n\n                enum UserType {\n                    JEDI\n                    BASIC\n                    DROID @deprecated\n                }\n                \n                type User {\n                    id: ID!\n                    name: String\n                    type: UserType\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("UserType");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLEnumType");
        GraphQLEnumType userTypeEnum = (GraphQLEnumType)graphQLType;
        GraphQLEnumValueDefinition droidValue = userTypeEnum.getValue("DROID");
        boolean bl = droidValue.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(droidValue.getDeprecationReason(), "No longer supported");
    }

    @Test
    public final void should apply @deprecated directive on enum value with custom reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users: UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n\n                enum UserType {\n                    JEDI\n                    BASIC\n                    DROID @deprecated(reason: \"This value is no longer used\")\n                }\n                \n                type User {\n                    id: ID!\n                    name: String\n                    type: UserType\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("UserType");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLEnumType");
        GraphQLEnumType userTypeEnum = (GraphQLEnumType)graphQLType;
        GraphQLEnumValueDefinition droidValue = userTypeEnum.getValue("DROID");
        boolean bl = droidValue.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(droidValue.getDeprecationReason(), "This value is no longer used");
    }

    @Test
    public final void should apply @deprecated directive on argument with default reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users(first: Int @deprecated): UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLFieldDefinition usersQuery = schema2.getQueryType().getField("users");
        GraphQLArgument firstArgument = usersQuery.getArgument("first");
        boolean bl = firstArgument.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(firstArgument.getDeprecationReason(), "No longer supported");
    }

    @Test
    public final void should apply @deprecated directive on argument with custom reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users(first: Int @deprecated(reason: \"Please do not use this argument\")): UserConnection\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLFieldDefinition usersQuery = schema2.getQueryType().getField("users");
        GraphQLArgument firstArgument = usersQuery.getArgument("first");
        boolean bl = firstArgument.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(firstArgument.getDeprecationReason(), "Please do not use this argument");
    }

    @Test
    public final void should apply @deprecated directive on directive argument with default reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase(firstCharacterOnly: Boolean @deprecated) on FIELD_DEFINITION\n\n                type Query {\n                    users: UserConnection\n                }\n\n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n\n                type UserEdge {\n                    node: User!\n                }\n\n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLDirective directive = schema2.getDirective("uppercase");
        GraphQLArgument argument = directive.getArgument("firstCharacterOnly");
        boolean bl = argument.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(argument.getDeprecationReason(), "No longer supported");
    }

    @Test
    public final void should apply @deprecated directive on directive argument with custom reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                directive @uppercase(firstCharacterOnly: Boolean @deprecated(reason: \"Do not use this thing\")) on FIELD_DEFINITION\n\n                type Query {\n                    users: UserConnection\n                }\n\n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n\n                type UserEdge {\n                    node: User!\n                }\n\n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLDirective directive = schema2.getDirective("uppercase");
        GraphQLArgument argument = directive.getArgument("firstCharacterOnly");
        boolean bl = argument.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(argument.getDeprecationReason(), "Do not use this thing");
    }

    @Test
    public final void should apply @deprecated directive on input field with default reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users(connectionInput: ConnectionInput): UserConnection\n                }\n                \n                input ConnectionInput {\n                    first: Int @deprecated\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("ConnectionInput");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInputObjectType");
        GraphQLInputObjectType connectionInputType = (GraphQLInputObjectType)graphQLType;
        GraphQLInputObjectField firstField = connectionInputType.getField("first");
        boolean bl = firstField.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(firstField.getDeprecationReason(), "No longer supported");
    }

    @Test
    public final void should apply @deprecated directive on input field with custom reason() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new UsersQueryResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    users(connectionInput: ConnectionInput): UserConnection\n                }\n                \n                input ConnectionInput {\n                    first: Int @deprecated(reason: \"Please do not use this field\")\n                }\n                \n                type UserConnection {\n                    edges: [UserEdge!]!\n                }\n                \n                type UserEdge {\n                    node: User!\n                } \n                \n                type User {\n                    id: ID!\n                    name: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQLType graphQLType = schema2.getType("ConnectionInput");
        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLInputObjectType");
        GraphQLInputObjectType connectionInputType = (GraphQLInputObjectType)graphQLType;
        GraphQLInputObjectField firstField = connectionInputType.getField("first");
        boolean bl = firstField.isDeprecated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertEquals(firstField.getDeprecationReason(), "Please do not use this field");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UserType;", "", "(Ljava/lang/String;I)V", "JEDI", "BASIC", "DROID", "graphql-java-tools"})
    private static final class UserType
    extends Enum<UserType> {
        public static final /* enum */ UserType JEDI = new UserType();
        public static final /* enum */ UserType BASIC = new UserType();
        public static final /* enum */ UserType DROID = new UserType();
        private static final /* synthetic */ UserType[] $VALUES;

        public static UserType[] values() {
            return (UserType[])$VALUES.clone();
        }

        public static UserType valueOf(String value) {
            return Enum.valueOf(UserType.class, value);
        }

        static {
            $VALUES = userTypeArray = new UserType[]{UserType.JEDI, UserType.BASIC, UserType.DROID};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UsersQueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "users", "Lgraphql/relay/Connection;", "Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UsersQueryResolver$User;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "User", "graphql-java-tools"})
    private static final class UsersQueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> users(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new User(1L, "Luke Skywalker", "Luke", "Skywalker", UserType.JEDI))).get(env);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"SimpleListConnection(lis\u2026UserType.JEDI))).get(env)");
            return connection;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UsersQueryResolver$User;", "", "id", "", "name", "", "firstName", "lastName", "type", "Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UserType;", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UserType;)V", "getFirstName", "()Ljava/lang/String;", "getId", "()J", "getLastName", "getName", "getType", "()Lgraphql/kickstart/tools/DeprecatedDirectiveTest$UserType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
        private static final class User {
            private final long id;
            @NotNull
            private final String name;
            @NotNull
            private final String firstName;
            @NotNull
            private final String lastName;
            @NotNull
            private final UserType type;

            public User(long id, @NotNull String name, @NotNull String firstName, @NotNull String lastName, @NotNull UserType type) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
                Intrinsics.checkNotNullParameter((Object)lastName, (String)"lastName");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.id = id;
                this.name = name;
                this.firstName = firstName;
                this.lastName = lastName;
                this.type = type;
            }

            public final long getId() {
                return this.id;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getFirstName() {
                return this.firstName;
            }

            @NotNull
            public final String getLastName() {
                return this.lastName;
            }

            @NotNull
            public final UserType getType() {
                return this.type;
            }

            public final long component1() {
                return this.id;
            }

            @NotNull
            public final String component2() {
                return this.name;
            }

            @NotNull
            public final String component3() {
                return this.firstName;
            }

            @NotNull
            public final String component4() {
                return this.lastName;
            }

            @NotNull
            public final UserType component5() {
                return this.type;
            }

            @NotNull
            public final User copy(long id, @NotNull String name, @NotNull String firstName, @NotNull String lastName, @NotNull UserType type) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
                Intrinsics.checkNotNullParameter((Object)lastName, (String)"lastName");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new User(id, name, firstName, lastName, type);
            }

            public static /* synthetic */ User copy$default(User user, long l, String string, String string2, String string3, UserType userType, int n, Object object) {
                if ((n & 1) != 0) {
                    l = user.id;
                }
                if ((n & 2) != 0) {
                    string = user.name;
                }
                if ((n & 4) != 0) {
                    string2 = user.firstName;
                }
                if ((n & 8) != 0) {
                    string3 = user.lastName;
                }
                if ((n & 0x10) != 0) {
                    userType = user.type;
                }
                return user.copy(l, string, string2, string3, userType);
            }

            @NotNull
            public String toString() {
                return "User(id=" + this.id + ", name=" + this.name + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", type=" + (Object)((Object)this.type) + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.id);
                result = result * 31 + this.name.hashCode();
                result = result * 31 + this.firstName.hashCode();
                result = result * 31 + this.lastName.hashCode();
                result = result * 31 + this.type.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof User)) {
                    return false;
                }
                User user = (User)other;
                if (this.id != user.id) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.name, (Object)user.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.firstName, (Object)user.firstName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.lastName, (Object)user.lastName)) {
                    return false;
                }
                return this.type == user.type;
            }
        }
    }
}

