/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/InaccessibleFieldResolverTest;", "", "<init>", "()V", "private field from closed module is not accessible", "", "private field from closed module is accessible through resolver", "Query", "LocaleResolver", "graphql-java-tools"})
public final class InaccessibleFieldResolverTest {
    @Test
    public final void private field from closed module is not accessible() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new Query()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    locale: Locale\n                }\n                \n                type Locale {\n                  country: String!\n                  languageTag: String!\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        GraphQL gql = graphQL;
        ExecutionResult result = gql.execute("\n            query {\n                locale {\n                    country\n                    languageTag\n                }\n            }\n            ");
        TestUtilsKt.assertEquals(result.getErrors().size(), 1);
        Object e = result.getErrors().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type graphql.ExceptionWhileDataFetching");
        ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)e;
        boolean bl = exceptionWhileDataFetching.getException() instanceof IllegalAccessException;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void private field from closed module is accessible through resolver() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new Query(), new LocaleResolver()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    locale: Locale\n                }\n                \n                type Locale {\n                  country: String!\n                  languageTag: String!\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        GraphQL gql = graphQL;
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(gql, null, null, InaccessibleFieldResolverTest::private_field_from_closed_module_is_accessible_through_resolver$lambda$0, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"country", (Object)"US"), TuplesKt.to((Object)"languageTag", (Object)"en-US")};
        TestUtilsKt.assertEquals(data.get("locale"), MapsKt.mapOf((Pair[])pairArray));
    }

    private static final String private_field_from_closed_module_is_accessible_through_resolver$lambda$0() {
        return "\n            query {\n                locale {\n                    country\n                    languageTag\n                }\n            }\n            ";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/InaccessibleFieldResolverTest$LocaleResolver;", "Lgraphql/kickstart/tools/GraphQLResolver;", "Ljava/util/Locale;", "<init>", "()V", "languageTag", "", "locale", "graphql-java-tools"})
    public static final class LocaleResolver
    implements GraphQLResolver<Locale> {
        @NotNull
        public final String languageTag(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            String string = locale.toLanguageTag();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/InaccessibleFieldResolverTest$Query;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "locale", "Ljava/util/Locale;", "graphql-java-tools"})
    public static final class Query
    implements GraphQLQueryResolver {
        @NotNull
        public final Locale locale() {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            return locale;
        }
    }
}

